/*
 * Decompiled with CFR 0.152.
 */
package com.steadystate.css.dom;

import com.steadystate.css.dom.DOMExceptionImpl;
import com.steadystate.css.dom.Property;
import com.steadystate.css.parser.CSSOMParser;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import org.w3c.css.sac.InputSource;
import org.w3c.dom.DOMException;
import org.w3c.dom.css.CSSRule;
import org.w3c.dom.css.CSSStyleDeclaration;
import org.w3c.dom.css.CSSValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSSStyleDeclarationImpl
implements CSSStyleDeclaration,
Serializable {
    private static final long serialVersionUID = -2373755821317100189L;
    private CSSRule parentRule;
    private List<Property> properties = new ArrayList<Property>();

    public void setParentRule(CSSRule parentRule) {
        this.parentRule = parentRule;
    }

    public List<Property> getProperties() {
        return this.properties;
    }

    public void setProperties(List<Property> properties) {
        this.properties = properties;
    }

    public CSSStyleDeclarationImpl(CSSRule parentRule) {
        this.parentRule = parentRule;
    }

    public CSSStyleDeclarationImpl() {
    }

    @Override
    public String getCssText() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.properties.size(); ++i) {
            Property p = this.properties.get(i);
            if (p != null) {
                sb.append(p.toString());
            }
            if (i >= this.properties.size() - 1) continue;
            sb.append("; ");
        }
        return sb.toString();
    }

    @Override
    public void setCssText(String cssText) throws DOMException {
        try {
            InputSource is = new InputSource((Reader)new StringReader(cssText));
            CSSOMParser parser = new CSSOMParser();
            this.properties.clear();
            parser.parseStyleDeclaration(this, is);
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public String getPropertyValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue().toString() : "";
    }

    @Override
    public CSSValue getPropertyCSSValue(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        return p != null ? p.getValue() : null;
    }

    @Override
    public String removeProperty(String propertyName) throws DOMException {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property p = this.properties.get(i);
            if (!p.getName().equalsIgnoreCase(propertyName)) continue;
            this.properties.remove(i);
            return p.getValue().toString();
        }
        return "";
    }

    @Override
    public String getPropertyPriority(String propertyName) {
        Property p = this.getPropertyDeclaration(propertyName);
        if (p != null) {
            return p.isImportant() ? "important" : "";
        }
        return "";
    }

    @Override
    public void setProperty(String propertyName, String value, String priority) throws DOMException {
        try {
            boolean important;
            InputSource is = new InputSource((Reader)new StringReader(value));
            CSSOMParser parser = new CSSOMParser();
            CSSValue expr = parser.parsePropertyValue(is);
            Property p = this.getPropertyDeclaration(propertyName);
            boolean bl = important = priority != null ? priority.equalsIgnoreCase("important") : false;
            if (p == null) {
                p = new Property(propertyName, expr, important);
                this.addProperty(p);
            } else {
                p.setValue(expr);
                p.setImportant(important);
            }
        }
        catch (Exception e) {
            throw new DOMExceptionImpl(12, 0, e.getMessage());
        }
    }

    @Override
    public int getLength() {
        return this.properties.size();
    }

    @Override
    public String item(int index) {
        Property p = this.properties.get(index);
        return p != null ? p.getName() : "";
    }

    @Override
    public CSSRule getParentRule() {
        return this.parentRule;
    }

    public void addProperty(Property p) {
        this.properties.add(p);
    }

    public Property getPropertyDeclaration(String name) {
        for (int i = 0; i < this.properties.size(); ++i) {
            Property p = this.properties.get(i);
            if (!p.getName().equalsIgnoreCase(name)) continue;
            return p;
        }
        return null;
    }

    public String toString() {
        return this.getCssText();
    }
}

