package Hailo::Role::Generic;
use 5.10.0;
use Moose::Role;
use MooseX::Types::Moose qw/HashRef/;
use namespace::clean -except => 'meta';

our $VERSION = '0.08';

has arguments => (
    isa           => HashRef,
    is            => 'ro',
    documentation => "Arguments passed from Hailo",
);

1;

=encoding utf8

=head1 NAME

Hailo::Role::Generic - A role used by all other L<Hailo|Hailo> roles

=head1 ATTRIBUTES

=head2 C<arguments>

A C<HashRef> of arguments passed to us from L<Hailo>'s
L<storage|Hailo/storage_args>, L<engine|Hailo/engine_args> or
L<tokenizer|Hailo/tokenizer_args> arguments.

=head1 AUTHOR

E<AElig>var ArnfjE<ouml>rE<eth> Bjarmason <avar@cpan.org>

=head1 LICENSE AND COPYRIGHT

Copyright 2010 E<AElig>var ArnfjE<ouml>rE<eth> Bjarmason.

This program is free software, you can redistribute it and/or modify
it under the same terms as Perl itself.

=cut

