# $File: /local/member/autrijus/Parse-AFP//lib/Parse/AFP/Record.pm $ $Author: autrijus $
# $Revision: #7 $ $Change: 2427 $ $DateTime: 2004-02-19T21:40:36.424632Z $

package Parse::AFP::Record;

use base 'Parse::AFP::Base';
use constant FORMAT => (
    CC		=> 'H2',
    Length	=> 'n',	    # length() + 2
    Type	=> 'H6',
    FlagByte	=> 'a',
    _		=> 'n',
    Data	=> 'a*',
);
use constant DISPATCH_FIELD => 'Type';
use constant DISPATCH_TABLE => (
    d3a088	=> 'MFC',	# Medium Finishing Control
    d3a090	=> 'TLE',	# Tag Logical Element
    d3a288	=> 'MCC',	# Medium Copy Count
    d3a66b	=> 'OBD',	# Object Area Descriptor
    d3a67b	=> 'IID',	# IM Image Input Descriptor (C)
    d3a688	=> 'MDD',	# Medium Descriptor
    d3a692	=> 'CDD',	# Container Data Descriptor
    d3a69b	=> 'PTD1',	# Presentation Text Descriptor Format-1 (C)
    d3a6af	=> 'PGD',	# Page Descriptor
    d3a6bb	=> 'GDD',	# Graphics Data Descriptor
    d3a6c5	=> 'FGD',	# Form Environment Group Descriptor (O)
    d3a6eb	=> 'BDD',	# Bar Code Data Descriptor
    d3a6fb	=> 'IDD',	# Image Data Descriptor
    d3a77b	=> 'IOC',	# IM Image Output Control (C)
    d3a788	=> 'MMC',	# Medium Modification Control
    d3a79b	=> 'CTC',	# Composed Text Control (O)
    d3a7af	=> 'PMC',	# Page Modification Control
    d3a85f	=> 'BPS',	# Begin Page Segment
    d3a877	=> 'BCA',	# Begin Color Attribute Table
    d3a87b	=> 'BII',	# Begin IM Image (C)
    d3a892	=> 'BOC',	# Begin Object Container
    d3a89b	=> 'BPT',	# Begin Presentation Text Object
    d3a8a7	=> 'BDI',	# Begin Document Index
    d3a8a8	=> 'BDT',	# Begin Document
    d3a8ad	=> 'BNG',	# Begin Named Page Group
    d3a8af	=> 'BPG',	# Begin Page
    d3a8bb	=> 'BGR',	# Begin Graphics Object
    d3a8c4	=> 'BDG',	# Begin Document Environment Group
    d3a8c5	=> 'BFG',	# Begin Form Environment Group (O)
    d3a8c6	=> 'BRG',	# Begin Resource Group
    d3a8c7	=> 'BOG',	# Begin Object Environment Group
    d3a8c9	=> 'BAG',	# Begin Active Environment Group
    d3a8cc	=> 'BMM',	# Begin Medium Map
    d3a8cd	=> 'BFM',	# Begin Form Map
    d3a8ce	=> 'BR',	# Begin Resource (R)
    d3a8d9	=> 'BSG',	# Begin Resource Environment Group
    d3a8df	=> 'BMO',	# Begin Overlay
    d3a8eb	=> 'BBC',	# Begin Bar Code Object
    d3a8fb	=> 'BIM',	# Begin Image Object
    d3a95f	=> 'EPS',	# End Page Segment
    d3a977	=> 'ECA',	# End Color Attribute Table
    d3a97b	=> 'EII',	# End IM Image (C)
    d3a992	=> 'EOC',	# End Object Container
    d3a99b	=> 'EPT',	# End Presentation Text Object
    d3a9a7	=> 'EDI',	# End Document Index
    d3a9a8	=> 'EDT',	# End Document
    d3a9ad	=> 'ENG',	# End Named Page Group
    d3a9af	=> 'EPG',	# End Page
    d3a9bb	=> 'EGR',	# End Graphics Object
    d3a9c4	=> 'EDG',	# End Document Environment Group
    d3a9c5	=> 'EFG',	# End Form Environment Group (O)
    d3a9c6	=> 'ERG',	# End Resource Group
    d3a9c7	=> 'EOG',	# End Object Environment Group
    d3a9c9	=> 'EAG',	# End Active Environment Group
    d3a9cc	=> 'EMM',	# End Medium Map
    d3a9cd	=> 'EFM',	# End Form Map
    d3a9ce	=> 'ER',	# End Resource (R)
    d3a9d9	=> 'ESG',	# End Resource Environment Group
    d3a9df	=> 'EMO',	# End Overlay
    d3a9eb	=> 'EBC',	# End Bar Code Object
    d3a9fb	=> 'EIM',	# End Image Object
    d3ab77	=> 'MCA',	# Map Color Attribute Table
    d3ab88	=> 'MMT',	# Map Media Type
    d3ab8a	=> 'MCF',	# Map Coded Font
    d3ab92	=> 'MCD',	# Map Container Data
    d3abaf	=> 'MPG',	# Map Page
    d3abbb	=> 'MGO',	# Map Graphics Object
    d3abc3	=> 'MDR',	# Map Data Resource
    d3abcc	=> 'IMM',	# Invoke Medium Map
    d3abd8	=> 'MPO',	# Map Page Overlay
    d3abea	=> 'MSU',	# Map Suppression
    d3abeb	=> 'MBC',	# Map Bar Code Object
    d3abfb	=> 'MIO',	# Map Image Object
    d3ac6b	=> 'OBP',	# Object Area Position
    d3ac7b	=> 'ICP',	# IM Image Cell Position (C)
    d3acaf	=> 'PGP1',	# Page Position Format-1 (C)
    d3af5f	=> 'IPS',	# Include Page Segment
    d3afaf	=> 'IPG',	# Include Page
    d3afc3	=> 'IOB',	# Include Object
    d3afd8	=> 'IPO',	# Include Page Overlay
    d3b077	=> 'CAT',	# Color Attribute Table
    d3b15f	=> 'MPS',	# Map Page Segment
    d3b18a	=> 'MCF1',	# Map Coded Font Format-1 (C)
    d3b19b	=> 'PTD',	# Presentation Text Data Descriptor
    d3b1af	=> 'PGP',	# Page Position
    d3b1df	=> 'MMO',	# Map Medium Overlay
    d3b288	=> 'PFC',	# Presentation Fidelity Control
    d3b2a7	=> 'IEL',	# Index Element
    d3b490	=> 'LLE',	# Link Logical Element
    d3ee7b	=> 'IRD',	# IM Image Raster Data (C)
    d3ee92	=> 'OCD',	# Object Container Data
    d3ee9b	=> 'PTX',	# Presentation Text Data
    d3eebb	=> 'GAD',	# Graphics Data
    d3eeeb	=> 'BDA',	# Bar Code Data
    d3eeee	=> 'NOP',	# No Operation
    d3eefb	=> 'IPD',	# Image Picture Data
    d3a88a	=> 'BCF',	# Begin Coded Font
    d3a887	=> 'BCP',	# Begin Code Page
    d3a889	=> 'BFN',	# Begin Font
    d3a78a	=> 'CFC',	# Coded Font Control
    d38c8a	=> 'CFI',	# Coded Font Index
    d3a787	=> 'CPC',	# Code Page Control
    d3a687	=> 'CPD',	# Code Page Descriptor
    d38c87	=> 'CPI',	# Code Page Index
    d3a98a	=> 'ECF',	# End Coded Font
    d3a987	=> 'ECP',	# End Code Page
    d3a989	=> 'EFN',	# End Font
    d3a789	=> 'FNC',	# Font Control
    d3a689	=> 'FND',	# Font Descriptor
    d3ee89	=> 'FNG',	# Font Patterns
    d38c89	=> 'FNI',	# Font Index
    d3a289	=> 'FNM',	# Font Patterns Map
    d3ab89	=> 'FNN',	# Font Names (Outline Fonts Only)
    d3ae89	=> 'FNO',	# Font Orientation
    d3ac89	=> 'FNP',	# Font Position
);

1;
