use Evo::Base -strict;
use Test::More tests => 7;

use Promises6 ':all';
use Evo::Manager;

my $m = Evo::Manager->singleton;
my $p;

sub resolve_later ($interval, $val) {
  die "provide interval in seconds" unless $interval + 1;
  promise {
    my $resolve = shift;
    $resolve->($val);
  }
}

$p = promise {
  my ($resolve, $reject, $notify) = @_;

  then sub { is shift(), 'hello'; rejected('bye') };

  then sub {fail}, sub { is shift(), 'bye'; 'here' };
  when_ok { is shift, 'here'; die "Foo" };
  when_rejected { like shift(), qr/Foo/, 'rejected'; 'next' };

  when_ok { is shift, 'next'; resolve_later(0, 'delayed') };
  $resolve->('hello');
};


$p = promise {
  my ($resolve, $reject, $notify) = @_;

  when_progress { is $_[0], 10, 'when_progress'; $_[0] + 1 };
  then undef, undef, sub($p) { is $p, 11, 'then 3 arg' };

  $notify->(10);
  sub { $resolve->('hello') }
};

