use Evo::Base -strict;
use Test::More;
use Promises6 'deferred';

my $d = deferred;

my @results;

sub store : prototype() {
  sub($v) { push @results, $v };
}

my $delayed = deferred->promise;
$d->promise->then(sub($v) {$delayed})->then(sub ($v) {"$v-a1"})->then(store);
$d->promise->then(sub($v) {"$v-b1"})->then(sub($v)   {"$v-b2"})->then(store);

$d->resolve('S');
is_deeply [sort @results], [sort qw(S-b1-b2 )], 'right flow not resolved yet';

$delayed->deferred->resolve('delayed');
is_deeply [sort @results], [sort qw(delayed-a1 S-b1-b2 )], 'resolved';

done_testing;
