package main;
use FindBin;
use lib "$FindBin::Bin/lib";
use Mojo::Base -strict;

use Promises6 ':dsl';

# check 'lib' dir
use UAP;

my $ua             = UAP::->new;
my $ioloop         = Mojo::IOLoop->singleton;
my $AWESOME_PERSON = 'http://alexbyk.com';

# this is just a little example
# visit site of the awesome person, get a link to my blog and visit it.
# With progress notifications!
#
# see the same example using OO syntax in ua-promises.pl


promise {
  my ($resolve, $reject, $progress) = @_;

  # download alexbyk.com
  $resolve->($ua->get($AWESOME_PERSON));

  # parse link and download it
  when_ok {
    my $link = shift->dom->at('a')->{href};
    $ua->get($link);
  };

  # got link, print content
  when_ok { say "content: ", substr(shift()->body, 0, 300); };


  # print progress notifications
  when_progress { say "[progress] ${\shift()->content->progress} bytes"; };

  # handle errors
  when_rejected { my $reason = shift; warn "Rejected:  $reason"; };

  # always here, because we handled an error in prev step
  when_ok { $ioloop->stop };
};

# show that we're non blocking
my $i = 0;
$ioloop->recurring(0.2 => sub { say '[timer] ', $i += 0.2, ' secs passed' });
$ioloop->start;
