use Evo::Base -strict;
use Test::More;
use Railway::Builder;
use Test::Fatal;

my $bldr = Railway::Builder->new;

my @passed;
my $way
  = $bldr->build_way->add(sub { push @passed, shift })
  ->add(sub { push @passed, 2; })
  ->add(sub { push @passed, 3; shift->power(0) })
  ->add(sub { push @passed, 'bad' });

$bldr->build_train(way => $way)->done(sub {fail})->prepare->run;
isa_ok((shift @passed), $bldr->train_class, 'train is first arg');
is_deeply \@passed, [2, 3], 'right flow';

@passed = ();
my $tr = $bldr->build_train;
$tr->way->add(sub { });
$tr->start(sub { push @passed, shift });
is_deeply \@passed, [$tr], 'passed to finish';

like exception { $bldr->build_train->run }, qr/no power/,
  'not started without prepare';

like exception { $bldr->build_train->power(0) }, qr/same power/i, 'same power';

done_testing;
