# Copyright: 2004 The Perl Foundation.  All Rights Reserved.
# $Id: Libs.pm,v 1.4 2004/03/07 10:02:41 mikescott Exp $

=head1 NAME

Parrot::Docs::Libs - Parrot libraries docmentation section

=head1 SYNOPSIS

	use Parrot::Docs::Libs;
	
	my $section = Parrot::Docs::Libs->new;

=head1 DESCRIPTION

A documentation section describing libraries in Parrot.

=head2 Methods

=over

=cut

package Parrot::Docs::Section::Libs;

use strict;

use Parrot::Docs::Section;
@Parrot::Docs::Section::Libs::ISA = qw(Parrot::Docs::Section);

=item C<new()>

Returns the libraries section.

=cut

sub new
{
	my $self = shift;
	
	return $self->SUPER::new(
		'Libraries', 'libs.html', '',
		$self->new_group('Parrot Core Libraries', '', 'library'),
		$self->new_group('Dynamic Libraries', '', 'dynoplibs'),
	);
}

=back

=cut

1;