use strict;
use warnings;
use autodie;

use Text::Table::Read::RelationOn::Tiny;

use constant RELATION_ON => "Text::Table::Read::RelationOn::Tiny"; # to make calls shorter.

my $tab1 = <<'FOT';
      | x\y     | that | this | empty | next | foo bar |
      |---------+------+------+-------+------+---------|
      | this    |      | X    |       |      | X       |
      |---------+------+------+-------+------+---------|
      | that    |      |      |       |      | X       |
      |---------+------+------+-------+------+---------|
      | foo bar | X    |      |       | X    |         |
      |---------+------+------+-------+------+---------|
      | empty   |      |      |       | X    |         |
      |---------+------+------+-------+------+---------|
      | next    |      | X    |       |      |         |
      |---------+------+------+-------+------+---------|


FOT
#Don't append a semicolon to the line above!


###############################################################

    my $input = <<'EOT';

      | x\y     | this | that | foo bar | empty |
      |---------+------+------+---------+-------|
      | this    | X    |      | X       |       |
      |---------+------+------+---------+-------|
      | that    |      |      | X       |       |
      |---------+------+------+---------+-------|
      | foo bar |      | X    |         |       |
      |---------+------+------+---------+-------|
      | empty   |      |      |         |       |
      |---------+------+------+---------+-------|

EOT

    my $input2 = <<'EOT';

      | x\y     | empty | foo bar | this | that |
      |---------+-------+---------+------+------|
      | this    |       | X       | X    |      |
      |---------+-------+---------+------+------|
      | that    |       | X       |      |      |
      |---------+-------+---------+------+------|
      | empty   |       |         |      |      |
      |---------+-------+---------+------+------|
      | foo bar |       |         |      | X    |
      |---------+-------+---------+------+------|

EOT


my @set_array = ('this', 'that', 'foo bar', 'empty');

my $obj = RELATION_ON->new(set => \@set_array);
#my $obj = RELATION_ON->new();

use Data::Dumper;

$obj->get($input);

print(Dumper($obj->elems));
print(Dumper($obj->elem_ids));
print(Dumper($obj->matrix));

$obj->get($input2);

print "=======================\n";
print(Dumper($obj->elems));
print(Dumper($obj->elem_ids));
print(Dumper($obj->matrix));


print "DONE\n";
