/*
 * Decompiled with CFR 0.152.
 */
package javax.media.jai.registry;

import java.awt.image.renderable.ParameterBlock;
import javax.media.jai.CollectionImage;
import javax.media.jai.CollectionOp;
import javax.media.jai.JAI;
import javax.media.jai.OperationRegistry;
import javax.media.jai.PropertySource;
import javax.media.jai.RenderableCollectionImageFactory;
import javax.media.jai.registry.JaiI18N;

public final class RCIFRegistry {
    private static final String MODE_NAME = "renderableCollection";

    public static void register(OperationRegistry operationRegistry, String string, RenderableCollectionImageFactory renderableCollectionImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.registerFactory(MODE_NAME, string, null, renderableCollectionImageFactory);
    }

    public static void unregister(OperationRegistry operationRegistry, String string, RenderableCollectionImageFactory renderableCollectionImageFactory) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        operationRegistry.unregisterFactory(MODE_NAME, string, null, renderableCollectionImageFactory);
    }

    public static RenderableCollectionImageFactory get(OperationRegistry operationRegistry, String string) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        return (RenderableCollectionImageFactory)operationRegistry.getFactory(MODE_NAME, string);
    }

    public static CollectionImage create(OperationRegistry operationRegistry, String string, ParameterBlock parameterBlock) {
        operationRegistry = operationRegistry != null ? operationRegistry : JAI.getDefaultInstance().getOperationRegistry();
        Object[] objectArray = new Object[]{parameterBlock};
        return (CollectionImage)operationRegistry.invokeFactory(MODE_NAME, string, objectArray);
    }

    public static PropertySource getPropertySource(CollectionOp collectionOp) {
        if (collectionOp == null) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("Generic0"));
        }
        if (!collectionOp.isRenderable()) {
            throw new IllegalArgumentException("op - " + JaiI18N.getString("CIFRegistry1"));
        }
        return collectionOp.getRegistry().getPropertySource(collectionOp);
    }
}

