package ZCS::Admin::Types::UserAgentSpecifier;
use strict;
use warnings;


__PACKAGE__->_set_element_form_qualified(1);

sub get_xmlns { 'urn:zimbra' };

our $XML_ATTRIBUTE_CLASS = 'ZCS::Admin::Types::UserAgentSpecifier::_UserAgentSpecifier::XmlAttr';

sub __get_attr_class {
    return $XML_ATTRIBUTE_CLASS;
}

use base qw(
    SOAP::WSDL::XSD::Typelib::ComplexType
    SOAP::WSDL::XSD::Typelib::Builtin::string
);

package ZCS::Admin::Types::UserAgentSpecifier::_UserAgentSpecifier::XmlAttr;
use base qw(SOAP::WSDL::XSD::Typelib::AttributeSet);

{ # BLOCK to scope variables

my %name_of :ATTR(:get<name>);
my %version_of :ATTR(:get<version>);

__PACKAGE__->_factory(
    [ qw(
        name
        version
    ) ],
    {

        name => \%name_of,

        version => \%version_of,
    },
    {
        name => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
        version => 'SOAP::WSDL::XSD::Typelib::Builtin::string',
    }
);

} # end BLOCK



1;


=pod

=head1 NAME

ZCS::Admin::Types::UserAgentSpecifier

=head1 DESCRIPTION

Perl data type class for the XML Schema defined complexType
UserAgentSpecifier from the namespace urn:zimbra.






=head2 PROPERTIES

The following properties may be accessed using get_PROPERTY / set_PROPERTY
methods:

=over



=back


=head1 METHODS

=head2 new

Constructor. The following data structure may be passed to new():

 { value => $some_value },



=head2 attr

NOTE: Attribute documentation is experimental, and may be inaccurate.
See the correspondent WSDL/XML Schema if in question.

This class has additional attributes, accessibly via the C<attr()> method.

attr() returns an object of the class ZCS::Admin::Types::UserAgentSpecifier::_UserAgentSpecifier::XmlAttr.

The following attributes can be accessed on this object via the corresponding
get_/set_ methods:

=over

=item * name



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::string|SOAP::WSDL::XSD::Typelib::Builtin::string>.

=item * version



This attribute is of type L<SOAP::WSDL::XSD::Typelib::Builtin::string|SOAP::WSDL::XSD::Typelib::Builtin::string>.


=back




=head1 AUTHOR

Generated by SOAP::WSDL

=cut

