(* Copyright (C) 1995, Digital Equipment Corporation                         *)
(* Digital Internal Use Only                                                 *)
(* All rights reserved.                                                      *)
(*                                                                           *)
(* Last modified on Thu Feb  2 14:19:39 PST 1995 by najork                   *)
(*       Created on Thu Feb  2 13:15:05 PST 1995 by najork                   *)


INTERFACE WinLL;

(* WinLL provides infrastructure for deciding whether the current thread holds
   a lock or not. 

   The rationale for this module is as follows: The "window procedure" of a 
   Windows program is called in response to client actions, from the 
   GetMessage-DispatchMessage loop in the client program. But it is also 
   directly called by certain Windows operations (CreateWindow, ShowWindow,
   UpdateWindow, ...). In the former case, the locking level of WindowProc 
   is 0, in the latter case, it is the same as the locking level of the 
   context of the Windows operation (eg ShowWindow). So, we can't decide 
   statically what the locking level of WindowProc is. 

   However, if we want to call other Trestle operations from the window 
   procedure, we have to ensure that the call occurs at the right locking 
   level. One way to do this is by explicitly keeping track of locking levels,
   when we cross the boundary from Trestle into winvbt. This module provides
   support for this. *)

PROCEDURE Assert (m: MUTEX);
(* Assert that the current thread holds the lock "m". 
   (However, is does not acquire "m") *)

PROCEDURE Retract (m: MUTEX);
(* Retract the assertion that the current thread holds "m". *)

PROCEDURE Acquire (m: MUTEX);
(* Acquire "m" if the current thread is not within an assert-retract 
   bracket. Otherwise, do nothing. *)

PROCEDURE Release (m: MUTEX);
(* Release "m" if the current thread is not within an assert-retract 
   bracket. Otherwise, do nothing. *)

END WinLL.
