(* Copyright (C) 1993, Digital Equipment Corporation           *)
(* All rights reserved.                                        *)

(* The "BoardX" interface allows the server to create a
   useful subtype of "Board.T".
*)

INTERFACE BoardX;

IMPORT Board, Item, Wr, Rd, Pickle, Thread;

TYPE T <: Public;
     Public = Board.T OBJECT
     METHODS
       init(): T;
       initT();
       initS();
       createItemsState(its: Item.TArray): Item.IDArray;
       modifyItemsState(its: Item.TArray);
       deleteItemsState(ids: Item.IDArray);
       putState(wr: Wr.T) 
          RAISES {Pickle.Error, Wr.Failure, Thread.Alerted};
       getState(rd: Rd.T): T 
          RAISES {Pickle.Error, Rd.Failure, Rd.EndOfFile, Thread.Alerted};
     END;
     <*PRAGMA STABLE *>
     <*STABLE UPDATE METHODS initS, createItemsState, modifyItemsState, 
                             deleteItemsState *>

(* The "stable" argument to the "init" method is where the board must
   log updates or save a snapshot. 
   If "recover" is true then the board must recover its
   set of items from "stable", otherwise it must initialize the
   "stable" to be an empty set of items.
*)

PROCEDURE Busy (board: T): BOOLEAN;
(* Returns false iff the board has no clients (more specifically, if the board
   knows of no live clients).
*)

PROCEDURE Quit (board: T);
(* Terminate all threads, and ready for GC.
   WARNING: not implemented. *)

CONST Brand = "BoardX";

END BoardX. 
