/* IntVect.c -- Data type-specific functions for class IntVec

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith

Function:
	
Data type -specific functions for class IntVec.

Modification History:

$Log:	IntVect.c,v $
 * Revision 2.204  89/10/08  09:42:50  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/14  11:23:40  ted
 * Removed register decl's
 * 
 * Revision 2.202  89/06/28  23:33:40  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201  89/05/12  13:46:21  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200  89/05/03  23:35:52  keith
 * Utilize abstract classes.
 * 
 * Revision 2.122  89/05/03  23:33:09  keith
 * 
 * 
 * Revision 2.121  89/04/25  13:32:40  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:22:40  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  88/07/17  12:48:58  keith
 * Update for revised NIHCL Object I/O.
 * 
 * Revision 2.0  88/03/29  21:56:10  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  09:47:17  keith
 * Initial revision
 * 
	
*/

#include "IntVec.h"
#include "nihclconfig.h"
#include "nihclIO.h"
#include <libc.h>

#define	THIS	IntVec
#define	BASE	Vector

static int typeCmp(const void* a, const void* b)
{
	return *(const int*)a-*(const int*)b;
}

void THIS::sort()
{
	qsort(v,n,sizeof(THIS),typeCmp);
}

unsigned THIS::hash() const
{
	unsigned h = n;
	unsigned i = n;
	int* vv = v;
	while (i--) h ^= (unsigned)*vv++;
	return h;
}

void THIS::printOn(ostream& strm) const
{
	for (int i=0; i<n; i++) {
		if (i>0 && (i%8 == 0)) strm << "\n\t";
		strm << dec(v[i],10);
	}
}

void THIS::scanFrom(istream& strm)
{
	extern const int NIHCL_NYET;
	setError(NIHCL_NYET,DEFAULT,className(),"scanFrom");
}
