/* Test class Regex

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	regex.c,v $
 * Revision 2.204  89/10/07  23:51:24  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:37  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:23:55  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/11  22:25:19  keith
 * Update for R2.0.
 * 
 * Revision 2.200.1.1  89/05/10  23:01:22  keith
 * Modify for abstract OIO classes.
 * 
 * Revision 2.200  89/04/24  17:35:26  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:22:08  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  89/02/08  14:04:57  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.0  88/03/29  13:28:04  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:25:04  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: regex.c,v 2.204 89/10/07 23:51:24 keith Stab $";

#include "Regex.h"
#include "OIOnih.h"
#include <fcntl.h>
#include <osfcn.h>

void printGroups(const Regex& r, const String& s, ostream& strm =cout)
{
	for (int i=0; i<r.groups(); i++) {
		strm << '\\' << i << ":	" << ((String&)s)(r[i])
			<< "	[" << s << '(' << r[i] << ")]\n";
	}
}

void testPattern(Regex& r, const String& s, ostream& strm =cout)
{
	strm << r << " match(" << s << ")? "
		<< (r.match(s) ? "YES" : "NO") << endl;
	printGroups(r,s);
	strm << r << " search(" << s << ")? "
		<< (r.search(s) != -1 ? "YES" : "NO") << endl;
	printGroups(r,s);
	strm << r << " search(" << s << ',' << s.length()-1 << ',' << -(int)s.length()+1 << ")? "
		<< (r.search(s,s.length()-1,-s.length()+1) != -1 ? "YES" : "NO") << endl;
	printGroups(r,s);
	cout << "---\n";
}

const char* fileName = "regex.obj";

main()
{
	cout << "\nTest Class Regex\n";
	Regex r = "\\([^a-zA-Z]*\\)\\([a-zA-Z]+\\)\\([^a-zA-Z]*\\)";
	testPattern(r,"123First123456789");
	Regex r2 = r;
	testPattern(r2,"123First123456789");
	Regex r3;
	r3 = r;
	testPattern(r3,"123First123456789");
	ostream* out = new ostream(creat(fileName,0664));
	r3.storeOn(OIOnihout(*out));
	delete out;
	istream* in = new istream(open(fileName,O_RDONLY));
	Regex* rp = Regex::readFrom(OIOnihin(*in));
	delete in;
	testPattern(*rp,"123First123456789");

	String s;
	while (YES) {
		cout << "Enter PATTERN: "; cin >> r;
		if (cin.eof()) exit(0);
		while (YES) {
			cout << "Enter STRING: "; cin >> s;
			if (cin.eof()) exit(0);
			if (s.length()==0) break;
			testPattern(r,s);
		}
	}
}
