/* Test class Iterator

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	iterator.c,v $
 * Revision 2.204  89/10/07  23:50:41  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:51:17  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:22:22  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/11  22:24:51  keith
 * Update for R2.0.
 * 
 * Revision 2.200.1.2  89/05/10  22:56:09  keith
 * Modify for abstract OIO classes.
 * 
 * Revision 2.200.1.1  89/05/05  09:44:33  keith
 * Simplify delete for virtual destructors.
 * 
 * Revision 2.200  89/04/24  17:34:19  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:56  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.2  89/02/08  14:04:30  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.1  88/05/30  09:49:15  keith
 * Update for new dumpOn()/printOn() format.
 * 
 * Revision 2.0  88/03/29  13:27:06  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:48  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: iterator.c,v 2.204 89/10/07 23:50:41 keith Stab $";

#include "Iterator.h"
#include "LinkedList.h"
#include "OrderedCltn.h"
#include "Set.h"
#include "Point.h"
#include "LinkOb.h"
#include "OIOnih.h"
#include <fcntl.h>
#include <osfcn.h>

const char* fileName = "iterator.obj";

main()
{
	cout << "\nTest class Iterator" << endl;
	OrderedCltn c,x;
	{ for (int j=0; j<6; j++) c.add(*new Point(j,j)); }
	c.dumpOn(cout);  cout.flush();
	Set s;
	s = c.asSet();
	s.dumpOn(cout);  cout.flush();
	LinkedList l;
	Iterator i(s);
	Object* p;
	while (p = i++) l.add(*new LinkOb(*p));
	l.dumpOn(cout);  cout.flush();
	x.add(c); x.add(l);

    DO(x,Collection,cp) {
	cout << "\nTest Iterator(" << cp->className() << ").storeOn()" << endl;
	ostream* out = new ostream(creat(fileName,0664));
	Iterator ii(*cp);
	ii.dumpOn(cout);  cout.flush();
	{ for (int j=0; j<3; j++) cout << *ii++; }
	cout << endl;
	ii.dumpOn(cout);  cout.flush();
	ii.storeOn(OIOnihout(*out));
	delete out;

	cout << "\nTest Iterator(" << cp->className() << ") readFrom()" << endl;
	istream* in = new istream(open(fileName,O_RDONLY));
	Iterator* ip = Iterator::readFrom(OIOnihin(*in));
	ip->dumpOn(cout);  cout.flush();
	while (p = (*ip)++) cout << *p;
	delete in;
	Collection* tcp=(Collection*)ip->collection();
	delete ip;
	delete tcp;

	cout << "\nTest Iterator(" << cp->className() << ").deepCopy()" << endl;
	ip = Iterator::castdown(ii.deepCopy());
	ip->dumpOn(cout);  cout.flush();
	while (p = (*ip)++) cout << *p;
	cout << "\nTest Iterator(" << cp->className() << ").reset()" << endl;
	ip->reset();
	ip->dumpOn(cout);  cout.flush();
	while (p = (*ip)++) cout << *p;
	cout << endl;
	tcp=(Collection*)ip->collection();
	delete ip;
	delete tcp;
    } OD;
}
