/* Test class Dictionary

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet:keith@alw.nih.gov

Function:
	
Modification History:
	
$Log:	dict.c,v $
 * Revision 2.204  89/10/07  23:50:11  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  14:50:51  keith
 * Pre-release
 * 
 * Revision 2.201  89/05/12  13:21:35  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.1  89/05/11  22:24:12  keith
 * Update for R2.0.
 * 
 * Revision 2.200  89/04/24  17:33:12  keith
 * Base revision for R2.0.
 * 
 * Revision 2.121  89/02/26  22:20:04  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.1  89/02/08  14:04:10  ted
 * changed names from oops to nihcl
 * 
 * Revision 2.0  88/03/29  13:26:24  keith
 * Version 2 Release 2
 * 
 * Revision 1.1  88/01/17  22:24:35  keith
 * Initial revision
 * 

*/
static char rcsid[] = "$Header: dict.c,v 2.204 89/10/07 23:50:11 keith Stab $";

#include "Point.h"
#include "Dictionary.h"
#include "Assoc.h"
#include "Bag.h"
#include "OrderedCltn.h"

main()
{
	cout << "\nTest class Dictionary\n";
	Dictionary d(16);
	Assoc c(*new Point(1,3),*new Point(2,3));
	d.add(*new Assoc(*new Point(1,1),*new Point(2,1)));
	d.add(*new Assoc(*new Point(1,2),*new Point(2,2)));
	d.add(c);
	cout << "d = " << d << endl;
	cout << "d.atKey(Point(1,1)): " << *(d.atKey(Point(1,1))) << endl;
	d.atKey(Point(1,1),*new Point(3,1));
	cout << "d = " << d << endl;
	cout << "d.includesAssoc(c): " << d.includesAssoc(c) << endl;
	cout << "d.includesKey(*c.key()): " << d.includesKey(*c.key()) << endl;
	cout << "d.keyAtValue(Point(3,1)) = " << *d.keyAtValue(Point(3,1)) << endl;
	d.removeKey(*c.key());
	cout << "d.includesAssoc(c): " << d.includesAssoc(c) << endl;
	cout << "d.includesKey(*c.key()): " << d.includesKey(*c.key()) << endl;
	cout << "d.asBag: " << d.asBag() << endl;
	OrderedCltn keys,vals;
	cout << "d.addKeysTo(keys): " << d.addKeysTo(keys) << endl;
	cout << "d.addValuesTo(vals): " << d.addValuesTo(vals) << endl;
}
