#ifndef	SET_H
#define	SET_H

/*$Header: Set.h,v 2.204 89/10/07 23:21:35 keith Stab $*/

/* Set.h -- declarations for hash tables

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Set.h,v $
 * Revision 2.204  89/10/07  23:21:35  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:24:23  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:56:05  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:56:05  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:17:25  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:27  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:44:09  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:25  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  11:01:46  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:59:52  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:10:20  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:18:28  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:24  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:09:23  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Collection.h"
#include "ArrayOb.h"

class Set: public Collection {
	DECLARE_MEMBERS(Set);
	unsigned count;		// number of objects in set 
	unsigned nbits;		// log base 2 of contents.capacity() 
protected:
	unsigned mask;		// contents.capacity()-1 
	ArrayOb contents;	// array of set objects 
	unsigned setCapacity(unsigned);	// compute set allocation size 
	int h(unsigned long) const;	// convert hash key into contents index 
	virtual int findIndexOf(const Object&) const;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Set(unsigned size =DEFAULT_CAPACITY);
	void operator=(const Set&);
	bool operator==(const Set&) const;
	bool operator!=(const Set& a) const	{ return !(*this==a); }
	Set operator&(const Set&) const;	// intersection 
	Set operator|(const Set&) const;	// union 
	Set operator-(const Set&) const;	// difference 
	virtual	Object*	add(Object&);
	virtual Object*& at(int);
	virtual const Object *const& at(int) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object*	doNext(Iterator&) const;
	virtual	Object* findObjectWithKey(const Object&) const;
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual void reSize(unsigned);
	virtual Object*	remove(const Object&);
	virtual void removeAll();
	virtual unsigned size() const;
	virtual const Class* species() const;
private:				// shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
