#ifndef	REGEX_H
#define	REGEX_H

/*$Header: Regex.h,v 2.204 89/10/07 23:21:21 keith Stab $*/

/* Regex.h -- header file for class Regex

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	December, 1987

$Log:	Regex.h,v $
 * Revision 2.204  89/10/07  23:21:21  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:24:03  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/07  14:03:42  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:55:47  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:47  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:16:50  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/21  11:19:37  keith
 * Make DEFAULT_BUFSIZE static member.
 * 
 * Revision 2.201.1.2  89/06/01  23:17:15  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:47  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:08  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  11:00:56  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:51  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:31:02  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:47  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 */

#include "String.h"
#include "Range.h"
#include "regex.h"

class Regex: public String {
	DECLARE_MEMBERS(Regex);
	struct re_pattern_buffer pattern;
	unsigned ngroups;	// 1 + number of \( \) groups in pattern
	struct re_registers regs;
	void re_compile_pattern();
	int re_match(const String&, int pos=0);
	void init(int bufsize);
	void fixCopy();
	void setGroups(int);
	void errRegex(const char*) const;
public:
	static const unsigned DEFAULT_BUFSIZE;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Regex(unsigned bufsize =DEFAULT_BUFSIZE);
	Regex(const char*, unsigned bufsize =DEFAULT_BUFSIZE);
	Regex(const Regex&);
	~Regex();
	operator const char*() const	{ return *(const String*)this; }
	Range operator[](unsigned) const;
	unsigned groups() const	{ return ngroups; }
	bool match(const String&, int pos=0);
	int search(const String&, int startpos=0);
	int search(const String&, int startpos, int range);
	void operator=(const char*);
	void operator=(const String&);
	void operator=(const SubString&);
	void operator=(const Regex&);
	virtual void dumpOn(ostream& strm =cerr) const;
	virtual void deepenShallowCopy();
	virtual void scanFrom(istream& strm);
	virtual void toAscii();
	virtual void toLower();
	virtual void toUpper();
private:
	String& operator&=(const String&)	{ shouldNotImplement("operator&="); return *this; }
	String& operator&=(const SubString&)	{ shouldNotImplement("operator&="); return *this; }
	String& operator&=(const char*)		{ shouldNotImplement("operator&="); return *this; }
};


#endif
