#ifndef	RECTANGLE_H
#define	RECTANGLE_H

/*$Header: Rectangle.h,v 2.204 89/10/07 23:21:17 keith Stab $*/

/* Rectangle.h -- declarations for class Rectangle

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Rectangle.h,v $
 * Revision 2.204  89/10/07  23:21:17  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:58  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:42  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:41  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:16:42  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/21  11:17:17  keith
 * Change value Rectangle args to const Rectangle& args.
 * Remove areasOutside().
 * 
 * Revision 2.201.1.2  89/06/01  23:17:10  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:44  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:20:01  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  11:00:51  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:50  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:17:42  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:57  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:38  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"
#include "Point.h"
#include <math.h>

class Rectangle: public VIRTUAL Object {
	DECLARE_MEMBERS(Rectangle);
	Point tl;		// top left corner (origin)
	Point br;		// bottom right corner (corner)
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Rectangle(int left=0, int top=0, int height=0, int width=0);
	Rectangle(const Point&, const Point&);
	Point origin() const		{ return tl; }
	Point origin(const Point& p)	{ return tl = p; }
	Point corner() const		{ return br; }
	Point corner(const Point& p)	{ return br = p; }
	Point topLeft() const		{ return tl; }
	Point topCenter() const		{ return Point((br.x()+tl.x())/2,tl.y()); }
	Point topRight() const		{ return Point(br.x(),tl.y()); }
	Point rightCenter() const	{ return Point(br.x(),(br.y()+tl.y())/2); }
	Point bottomRight() const	{ return br; }
	Point bottomCenter() const	{ return Point((br.x()+tl.x())/2,br.y()); }
	Point bottomLeft() const	{ return Point(tl.x(),br.y()); }
	Point leftCenter() const	{ return Point(tl.x(),(br.y()+tl.y())/2); }
	Point center() const		{ return Point((br.x()+tl.x())/2,(br.y()+tl.y())/2); }
	Point extent() const		{ return Point(br.x()-tl.x(),br.y()-tl.y()); }
	int area() const		{ return (br.x()-tl.x())*(br.y()-tl.y()); }
	int width() const		{ return br.x()-tl.x(); }
	int height() const		{ return br.y()-tl.y(); }
	bool operator==(const Rectangle&) const;
	bool operator!=(const Rectangle& r) const	{ return !(*this==r); }
	Rectangle operator&&(const Rectangle&) const;	// intersection 
	Rectangle operator||(const Rectangle&) const;	// union 
	void operator+=(const Point&);			// translate 
	void operator-=(const Point&);
	bool contains(const Point&) const;
	bool contains(const Rectangle&) const;
	bool intersects(const Rectangle&) const;
	void moveTo(const Point&);
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;	// equality test 
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

#endif
