#ifndef	POINT_H
#define	POINT_H

/*$Header: Point.h,v 2.204 89/10/07 23:20:57 keith Stab $*/

/* Point.h -- declarations for X-Y coordinates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Point.h,v $
 * Revision 2.204  89/10/07  23:20:57  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:23:39  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:26  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:24  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:16:10  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/21  11:10:32  keith
 * Change value Point args to const Point& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:58  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:31  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:19:38  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  11:00:22  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:58  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:36  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:08:02  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"
#include <math.h>

class Point: public VIRTUAL Object {
	DECLARE_MEMBERS(Point);
protected:
	short xc,yc;			// x-y coordinate 
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Point()				{ xc = yc = 0; }
	Point(short newx, short newy)	{ xc=newx; yc=newy; }
	short x() const			{ return xc; }
	short x(short newx)		{ return xc = newx; }
	short y() const			{ return yc; }
	short y(short newy)		{ return yc = newy; }
	Point operator+(const Point& p) const	{ return Point(xc+p.xc, yc+p.yc); }
	Point operator-() const			{ return Point(-xc,-yc); }
	Point operator-(const Point& p) const	{ return Point(xc-p.xc, yc-p.yc); }
	friend Point operator*(const Point& p, int i) { return Point(i*p.xc, i*p.yc); }
	friend Point operator*(int i, const Point& p) { return Point(i*p.xc, i*p.yc); }
	int operator*(const Point& p) const	{ return xc*p.xc + yc*p.yc; }
	bool operator==(const Point& p) const	{ return (xc==p.xc && yc==p.yc); }
	bool operator!=(const Point& p) const	{ return (xc!=p.xc || yc!=p.yc); }
	bool operator<(const Point& p) const	{ return (yc<p.yc && xc<p.xc); }
	bool operator<=(const Point& p) const	{ return (yc<=p.yc && xc<=p.xc); }
	bool operator>(const Point& p) const	{ return (yc>p.yc && xc>p.xc); }
	bool operator>=(const Point& p) const	{ return (yc>=p.yc && xc>=p.xc); }
	void operator+=(const Point& p)		{ xc += p.xc; yc += p.yc; }
	void operator-=(const Point& p)		{ xc -= p.xc; yc -= p.yc; }
	void operator*=(int s)			{ xc *= s; yc *= s; }
	double dist(const Point& p) const	{ return hypot(xc-p.xc, yc-p.yc); }
	Point max(const Point&) const;
	Point min(const Point&) const;
	Point transpose() const			{ return Point(yc,xc); }
 	bool isBelow(const Point& p) const	{ return yc > p.yc; }
	bool isAbove(const Point& p) const	{ return yc < p.yc; }
	bool isLeft(const Point& p) const	{ return xc < p.xc; }
	bool isRight(const Point& p) const	{ return xc > p.xc; }
	virtual	int compare(const Object&) const;	// compare Points 
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;	// equality test 
	virtual void printOn(ostream& strm =cout) const;
	virtual const Class* species() const;
};

#endif
