/* Point.c  -- implementation of X-Y coordinates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	August, 1985

Function:
	
A Point represents an x-y coordinate pair.  By convention, Point(0,0) is
the top left corner of the display, with x increasing to the right and y
increasing to the bottom.

$Log:	Point.c,v $
 * Revision 2.204  89/10/07  23:20:55  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/10  12:17:53  keith
 * Eliminate a castdown() from compare().
 * 
 * Revision 2.203  89/08/08  15:23:37  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:55:25  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:22  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/21  11:07:57  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Change value Point args to const Point& args.
 * Add explicit base class names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/05/25  09:57:26  ted
 * Changed casts to call castdown.
 * 
 * Revision 2.201  89/05/12  11:19:36  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  11:00:19  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:54  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:30:34  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:07:58  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Point.h"
#include "nihclIO.h"

#define	THIS	Point
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Point,1,"$Header: Point.c,v 2.204 89/10/07 23:20:55 keith Stab $",NULL,NULL);

Point Point::max(const Point& p) const
{
	return Point(MAX(xc,p.xc),MAX(yc,p.yc));
}

Point Point::min(const Point& p) const
{
	return Point(MIN(xc,p.xc),MIN(yc,p.yc));
}

bool Point::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && *this==castdown(ob);
}

const Class* Point::species() const	{ return &classDesc; }

unsigned Point::hash() const	{ return xc^yc; }

int Point::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	const Point& p = castdown(ob);
	int t = yc - p.yc;;
	if (t != 0) return t;
	else return xc - p.xc;
}

void Point::deepenShallowCopy()	{}

void Point::printOn(ostream& strm) const
{
	strm << '(' << xc << ',' << yc << ')';
}

Point::Point(OIOin& strm)
	: BASE(strm)
{
	strm >> xc >> yc;
}

void Point::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << xc << yc;
}

Point::Point(OIOifd& fd)
	: BASE(fd)
{
	fd >> xc >> yc;
}

void Point::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << xc << yc;
}
