#ifndef	ORDEREDCLTN_H
#define	ORDEREDCLTN_H

/*$Header: OrderedCltn.h,v 2.204 89/10/07 23:20:53 keith Stab $*/

/* OrderedCltn.h -- declarations for abstract ordered collections

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	OrderedCltn.h,v $
 * Revision 2.204  89/10/07  23:20:53  keith
 * Pre-release
 * 
 * Revision 2.203.1.1  89/09/09  20:09:50  keith
 * Eliminate isEqual() and species().
 * 
 * Revision 2.203  89/08/08  15:23:35  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/01  23:43:58  keith
 * Add copy constructors to fix yacc stack overflows
 * 
 * Revision 2.202.1.1  89/07/01  21:55:23  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:55:20  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:16:03  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:16:54  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:43:27  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:19:32  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.4  89/05/12  11:00:15  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.3  89/05/05  09:59:04  keith
 * Overload reference-returning member functions (e.g.
 * operator[](int) and at(int) for const instances.
 * 
 * Revision 2.200.1.2  89/05/03  23:09:17  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:50  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:54  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:07:55  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "SeqCltn.h"
#include "ArrayOb.h"

class OrderedCltn: public SeqCltn {
	DECLARE_MEMBERS(OrderedCltn);
	void errEmpty(const char* fn) const;
	void errNotFound(const char* fn, const Object& ob) const;
protected:
	int endIndex;
	ArrayOb contents;
	Object* addAtIndex(int i, Object& ob);
	Object* removeAtIndex(int i);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	OrderedCltn(unsigned size =DEFAULT_CAPACITY);
#ifndef BUG_TOOBIG
// yacc stack overflow
	OrderedCltn(const OrderedCltn&);
#endif
	bool operator!=(const OrderedCltn& a) const { return !(*this==a); }
	void operator=(const OrderedCltn&);
	bool operator==(const OrderedCltn&) const;
	Object*& operator[](int i) {
		if ((unsigned)i >= endIndex) indexRangeErr();
		return contents[i];
	}
	const Object *const& operator[](int i) const {
		if ((unsigned)i >= endIndex) indexRangeErr();
		return contents[i];
	}
	OrderedCltn operator&(const SeqCltn& cltn) const;	// concatenation operator 
	void operator&=(const SeqCltn& cltn);
	virtual Object* add(Object&);
	virtual Object* addAfter(const Object& ob, Object& newob);
	virtual Object* addAllLast(const OrderedCltn&);
	virtual Object* addBefore(const Object& ob, Object& newob);
	virtual Collection& addContentsTo(Collection& cltn) const;
	virtual Object* addLast(Object& ob);
	virtual Object* after(const Object&) const;
	virtual Object*& at(int i);
	virtual const Object *const& at(int i) const;
	virtual void atAllPut(Object& ob);
	virtual Object* before(const Object&) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();
	virtual Object* first() const;
	virtual unsigned hash() const;
 	virtual int indexOf(const Object& ob) const;
	virtual int indexOfSubCollection(const SeqCltn& cltn, int start=0) const;
	virtual bool isEmpty() const;
	virtual Object* last() const;
	virtual unsigned occurrencesOf(const Object&) const;
	virtual Object* remove(const Object&);
	virtual void removeAll();
	virtual Object* removeId(const Object&);
	virtual Object* removeLast();
	virtual void replaceFrom(int start, int stop, const SeqCltn& replacement, int startAt =0);
	virtual void reSize(unsigned newSize);
	virtual unsigned size() const;
	virtual void sort();
};

#endif
