/* LookupKey.c -- implementation of Dictionary LookupKey

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
LookupKey is an abstract class for managing the key object of an Assoc.
It is used to implement class Dictionary.

$Log:	LookupKey.c,v $
 * Revision 2.204  89/10/07  23:20:15  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:46  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:50  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:47  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  23:16:57  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:53:04  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:18:11  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:59:33  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:16:20  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:29:25  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:07:12  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "LookupKey.h"
#include "nihclIO.h"

#define	THIS	LookupKey
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(LookupKey,1,"$Header: LookupKey.c,v 2.204 89/10/07 23:20:15 keith Stab $",NULL,NULL);

LookupKey::LookupKey(Object& newKey)
{
	akey = &newKey;
}

Object* LookupKey::key() const { return akey; }

Object* LookupKey::key(Object& newkey)
{
	Object* temp = akey;
	akey = &newkey;
	return temp;
}

bool LookupKey::isEqual(const Object& ob) const { return ob.isEqual(*akey); }

unsigned LookupKey::hash() const { return akey->hash(); }

int LookupKey::compare(const Object& ob) const { return ob.compare(*akey); }

void LookupKey::deepenShallowCopy()
{
	akey = akey->deepCopy();
}

void LookupKey::dumpOn(ostream& strm) const
{
	strm << className() << '[';
	key()->dumpOn(strm);
	strm << "=>";
	value()->dumpOn(strm);
	strm << "]\n";
}

void LookupKey::printOn(ostream& strm) const
{
	key()->printOn(strm);
	strm << "=>";
	value()->printOn(strm);
}

Object* LookupKey::value() const
{
	derivedClassResponsibility("value"); return 0;
}

Object* LookupKey::value(Object& /*newvalue*/)
{
	derivedClassResponsibility("value"); return 0;
}

LookupKey::LookupKey(OIOin& strm)
	: BASE(strm)
{
	akey = Object::readFrom(strm);
}

void LookupKey::storer(OIOout& strm) const
{
	BASE::storer(strm);
	akey->storeOn(strm);
}

LookupKey::LookupKey(OIOifd& fd)
	: BASE(fd)
{
	akey = Object::readFrom(fd);
}

void LookupKey::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	akey->storeOn(fd);
}
