/* Integer.c -- implementation of Integer object

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	September, 1985

Function:
	
Provides an object that contains an int.

$Log:	Integer.c,v $
 * Revision 2.204  89/10/07  23:19:50  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:21  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:54:24  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:21  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/20  23:00:52  keith
 * Add Object::desc() to VIRTUAL_BASE_CLASSES.
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:57:34  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:17:38  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:58:57  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:23  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:56  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:16  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Integer.h"
#include "nihclIO.h"

#define	THIS	Integer
#define	BASE	Object
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES Object::desc()

DEFINE_CLASS(Integer,1,"$Header: Integer.c,v 2.204 89/10/07 23:19:50 keith Stab $",NULL,NULL);

Integer::Integer(istream& strm)		{ parseInteger(strm); }

unsigned Integer::hash() const { return val; }

bool Integer::isEqual(const Object& ob) const
{
	return ob.isSpecies(classDesc) && val==castdown(ob).val;
}

const Class* Integer::species() const { return &classDesc; }

int Integer::compare(const Object& ob) const
{
	assertArgSpecies(ob,classDesc,"compare");
	long t = val-castdown(ob).val;
	if (sizeof(long) > sizeof(int)) {
		if (t < 0) return -1;
		return (t > 0);
	}
	return t;
}

void Integer::deepenShallowCopy()	{}

void Integer::printOn(ostream& strm) const
{
	strm << val;
}

void Integer::scanFrom(istream& strm)	{ parseInteger(strm); }

Integer::Integer(OIOin& strm)
	: BASE(strm)
{
	strm >> val;
}

void Integer::storer(OIOout& strm) const
{
	BASE::storer(strm);
	strm << val;
}

Integer::Integer(OIOifd& fd)
	: BASE(fd)
{
	fd >> val;
}

void Integer::storer(OIOofd& fd) const
{
	BASE::storer(fd);
	fd << val;
}
