/* IdentSet.c -- implementation of Identity Set

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Bg. 12A, Rm. 2033
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-1111
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov
	April, 1988

Function:
	
An IdentSet is like a Set, except keys are compared using
isSame() rather than isEqual().

$Log:	IdentSet.c,v $
 * Revision 2.204  89/10/07  23:19:47  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:22:17  keith
 * Pre-release
 * 
 * Revision 2.202.1.3  89/07/08  19:11:39  keith
 * Add initialization of virtual base Object to readFrom() constructors
 * 
 * Revision 2.202.1.2  89/07/07  14:02:45  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:54:19  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:54:17  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:14:07  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/20  22:59:53  keith
 * Add explicit base names to constructor initializer lists.
 * 
 * Revision 2.201.1.1  89/06/13  22:52:44  keith
 * Base revision for Cycle 16.1.
 * 
 * Revision 2.201  89/05/12  11:17:17  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:58:50  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:15:15  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:52  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:05:09  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "IdentSet.h"

#define	THIS	IdentSet
#define	BASE	Set
#define BASE_CLASSES BASE::desc()
#define MEMBER_CLASSES
#define VIRTUAL_BASE_CLASSES

DEFINE_CLASS(IdentSet,0,"$Header: IdentSet.c,v 2.204 89/10/07 23:19:47 keith Stab $",NULL,NULL);

IdentSet::IdentSet(unsigned size) : BASE(size) {}

int IdentSet::findIndexOf(const Object& ob) const
/*
Search this IdentSet for the argument object.

Enter:
	ob = object to search for

Returns:
	index of object if found or of nil slot if not found
	
Algorithm L, Knuth Vol. 3, p. 519
*/
{
	register int i;
	for (i = h((const int)&ob); contents[i]!=nil; i = (i-1)&mask) {
		if (contents[i]->isSame(ob)) return i;
	}
	return i;
}

IdentSet::IdentSet(OIOin& strm)
:
#ifdef MI
	Object(strm),
#endif
	BASE(strm)
{
}

IdentSet::IdentSet(OIOifd& fd)
:
#ifdef MI
	Object(fd),
#endif
	BASE(fd)
{
}
