#ifndef	EXCEPTACT_H
#define	EXCEPTACT_H

/*$Header: ExceptAct.h,v 2.204 89/10/07 23:19:15 keith Stab $*/

/* ExceptAct.h -- declarations for exception actions

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	ExceptAct.h,v $
 * Revision 2.204  89/10/07  23:19:15  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:43  keith
 * Pre-release
 * 
 * Revision 2.202.1.2  89/07/07  14:02:31  keith
 * Clean up cast-away const where possible
 * 
 * Revision 2.202.1.1  89/07/01  21:53:42  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:42  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.2  89/06/22  10:13:07  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.1  89/06/01  23:15:13  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201  89/05/12  11:16:45  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:57:13  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:14:05  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:19  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:14  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Exception.h"
#include "nihclerrs.h"

class ExceptionAction;
class Process;

class ExceptionActionTbl : public NIHCL {
private:
	static ExceptionActionTbl* active;
	friend ExceptionAction;
	friend void NIHCL::setError(int error, int sev, ...);
	friend Process;
private:
	exceptionTrapTy client_exception_trap;
	exceptionActionTy action[NIHCL__LAST_ERROR-NIHCL__FIRSTERROR+1];
	friend ExceptionAction;
	friend AbortException;
	friend RaiseException;
	friend ExceptionTrap;
public:
	ExceptionActionTbl();
	void act(unsigned error, int sev);
};

#endif
