#ifndef	DATE_H
#define	DATE_H

/*$Header: Date.h,v 2.204 89/10/07 23:19:10 keith Stab $*/

/* Date.h -- declarations for Gregorian calendar dates

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Date.h,v $
 * Revision 2.204  89/10/07  23:19:10  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:33  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:35  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:34  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:12:54  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:43:18  keith
 * Replace value Date args by const Date& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:59  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:41:00  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:37  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:57:00  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:50  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:28:10  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:04:02  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
 * Revision 2.6  88/11/21  14:27:06  keith
 * Rewritten by Ted  to store julian day number as the implementation
 * private variable instead of year and day.
 * 
 * Revision 2.6  88/10/12  10:17:20  ted
 * Revamped to work with Julian day number instead of day and year.  Julian day number
 * is not what most programmers think of as Julian date; i.e., Jan. 29, 1988 is not the same
 * as 88029 in Julian day number.  They are different.
 * 
*/

#include "Object.h"

class Date: public VIRTUAL Object {
	DECLARE_MEMBERS(Date);
public:			// type definitions
	typedef unsigned short dayTy;
	typedef unsigned short monthTy;
	typedef unsigned short yearTy;
	typedef unsigned long  julTy;
public:			// static member functions
	static dayTy dayOfWeek(const char* dayName);
	static bool dayWithinMonth(monthTy month, dayTy day, yearTy year);
	static dayTy daysInYear(yearTy year);
	static julTy jday(monthTy m, dayTy d, yearTy y);
	static bool leapYear(yearTy year);
	static const char* nameOfDay(dayTy weekDayNumber);
	static const char* nameOfMonth(monthTy monthNumber);
	static monthTy numberOfMonth(const char* monthName);
private:		// private member variables
        julTy julnum;   // Julian Day Number (Not same as Julian date.  Jan. 29, 1988 
                        // is not the same as 88029 in Julian Day Number.)
	Date(julTy j)                   { julnum = j; }
	julTy parseDate(istream&);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Date();				// current date 
	Date(int dayCount);
	Date(int dayCount, yearTy referenceYear);
	Date(dayTy newDay, const char* monthName, yearTy newYear);
	Date(istream&);			// read date from stream 
	bool operator<(const Date& date) const	{ return julnum < date.julnum; }
	bool operator<=(const Date& date) const	{ return julnum <= date.julnum; }
	bool operator>(const Date& date) const	{ return date < *this; }
	bool operator>=(const Date& date) const	{ return date <= *this; }
	bool operator==(const Date& date) const	{ return julnum == date.julnum; }
	bool operator!=(const Date& date) const	{ return julnum != date.julnum; }
	friend Date operator+(const Date& dt, int dd)	{ return Date(dt.julnum + dd); }
	friend Date operator+(int dd, const Date& dt)	{ return Date(dt.julnum + dd); }
	int operator-(const Date& dt) const	{ return (int)(julnum - dt.julnum); }
	Date operator-(int dd) const		{ return Date(julnum - dd); }
	void operator+=(int dd)			{ julnum += dd; }
	void operator-=(int dd)			{ julnum -= dd; }
	bool between(const Date& d1, const Date& d2) const {
		return julnum >= d1.julnum && julnum <= d2.julnum;
	}
	dayTy day() const;
	dayTy dayOfMonth() const;
	dayTy firstDayOfMonth() const		{ return firstDayOfMonth(month()); }
	dayTy firstDayOfMonth(monthTy month) const;
	bool leap() const;
	Date max(const Date& dt) const { 
	        if (dt.julnum > julnum) return dt;
		else return *this;
        }
	void mdy(monthTy&,dayTy&,yearTy&) const;
	Date min(const Date& dt) const {
	        if (dt.julnum < julnum) return dt;
		else return *this;
        }
	monthTy	month() const;
	const char* nameOfMonth() const;
	Date previous(const char* dayName) const;
	dayTy weekDay() const;
	yearTy year() const;
	virtual int compare(const Object&) const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual void scanFrom(istream& strm);
	virtual const Class* species() const;
};

#endif
