#ifndef	BITBOARD_H
#define	BITBOARD_H

/*$Header: BitBoard.h,v 2.204 89/10/07 23:18:52 keith Stab $*/

/* BitBoard.h -- Declarations for class BitBoard

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	BitBoard.h,v $
 * Revision 2.204  89/10/07  23:18:52  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:17  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:15  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:19  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.4  89/06/22  10:12:15  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.3  89/06/20  22:14:04  keith
 * Replace BitBoard value args with const BitBoard& args.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:44  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:43  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:17  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.3  89/05/12  10:56:38  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.2  89/05/03  23:07:10  keith
 * Utilize abstract classes.
 * 
 * Revision 2.200.1.1  89/04/24  17:13:11  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:50  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:26  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "Object.h"

class BitBoard: public VIRTUAL Object {
	DECLARE_MEMBERS(BitBoard);
	union {
		unsigned long m[2];
		unsigned char c[8];
	};
public:
	static void init(const Class&);
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	BitBoard() {}
	BitBoard(unsigned i);
	BitBoard(unsigned long i, unsigned long j) { m[0] = i;  m[1] = j; }
	BitBoard operator~() const		{ return BitBoard(~m[0], ~m[1]); }
	BitBoard operator-(const BitBoard& n) const	{ return BitBoard(m[0]&~n.m[0], m[1]&~n.m[1]); }
	bool operator>(const BitBoard& n) const { return m[0] == (m[0]|n.m[0])
						&& m[0] != n.m[0]
						&& m[1] == (m[1]|n.m[1])
						&& m[1] != n.m[1]; }
	bool operator<(const BitBoard& n) const { return n > *this; }
	bool operator>=(const BitBoard& n) const { return m[0] == (m[0]|n.m[0])
						&& m[1] == (m[1]|n.m[1]); }
	bool operator<=(const BitBoard& n) const { return n >= *this; }
	bool operator==(const BitBoard& n) const { return m[0] == n.m[0] && m[1] == n.m[1]; }
	bool operator!=(const BitBoard& n) const { return m[0] != n.m[0] || m[1] != n.m[1]; }
	BitBoard operator|(const BitBoard& n) const { return BitBoard(m[0]|n.m[0], m[1]|n.m[1]); }
	BitBoard operator&(const BitBoard& n) const { return BitBoard(m[0]&n.m[0], m[1]&n.m[1]); }
	BitBoard operator^(const BitBoard& n) const { return BitBoard(m[0]^n.m[0], m[1]^n.m[1]); }
 	void operator-=(const BitBoard& n)	{ m[0] &= ~n.m[0]; m[1] &= ~n.m[1]; }
	void operator&=(const BitBoard& n)	{ m[0] &= n.m[0]; m[1] &= n.m[1]; }
	void operator^=(const BitBoard& n)	{ m[0] ^= n.m[0]; m[1] ^= n.m[1]; }
	void operator|=(const BitBoard& n)	{ m[0] |= n.m[0]; m[1] |= n.m[1]; }
	unsigned count() const;
	bool includes(unsigned i) const;
	virtual unsigned capacity() const;
	virtual void deepenShallowCopy();	// {}
	virtual unsigned hash() const;
	virtual bool isEmpty() const;
	virtual bool isEqual(const Object&) const;
	virtual void printOn(ostream& strm =cout) const;
	virtual unsigned size() const;
	virtual const Class* species() const;
private:			    // shouldNotImplement()
	virtual int compare(const Object&) const;
};

extern BitBoard squareBitBoard[64];
extern BitBoard rankBitBoard[8];
extern BitBoard fileBitBoard[8];
extern unsigned char bit_count[256];

inline BitBoard::BitBoard(unsigned i)	{ *this = squareBitBoard[i]; }
	
inline unsigned BitBoard::count() const
{
	register unsigned char* p = c;
	register unsigned n = 0;
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	n += bitCount(*p++);
	return n;
}

inline bool BitBoard::includes(unsigned i) const
{
	return (m[0] & squareBitBoard[i].m[0]) || (m[1] & squareBitBoard[i].m[1]);
}

#endif
