#ifndef	ASSOC_H
#define	ASSOC_H

/*$Header: Assoc.h,v 2.204 89/10/07 23:18:40 keith Stab $*/

/* Assoc.h -- declarations for key-value association

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	K. E. Gorlen
	Computer Systems Laboratory, DCRT
	National Institutes of Health
	Bethesda, MD 20892

$Log:	Assoc.h,v $
 * Revision 2.204  89/10/07  23:18:40  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/08  15:21:01  keith
 * Pre-release
 * 
 * Revision 2.202.1.1  89/07/01  21:53:03  keith
 * Base revision for R2.00 MI version
 * 
 * Revision 2.202  89/06/22  20:53:02  keith
 * Base revision for AT&T C++ R2.0 release (Cycle 20)
 * 
 * Revision 2.201.1.3  89/06/22  10:11:44  keith
 * Remove unnecessary copy constructors.
 * 
 * Revision 2.201.1.2  89/06/01  23:14:01  keith
 * Remove base class argument from DECLARE_MEMBERS.
 * 
 * Revision 2.201.1.1  89/05/19  15:40:15  keith
 * Add base class arg to DECLARE_MEMBERS.
 * Place enums and typedefs in classes.
 * 
 * Revision 2.201  89/05/12  11:16:02  keith
 * Release for R2.0 Beta test.
 * 
 * Revision 2.200.1.2  89/05/12  10:55:57  keith
 * Revised Object I/O.
 * 
 * Revision 2.200.1.1  89/04/24  17:12:14  keith
 * Working revision for R2.0 Beta 6++
 * 
 * Revision 2.200  89/04/17  23:27:35  keith
 * Base revision for R2.0 Beta 6.
 * 
 * Revision 2.121  89/02/16  11:03:03  keith
 * Base revision for C++ R1.2.1 compatible version.
 * 
*/

#include "LookupKey.h"

class Assoc: public LookupKey {
	DECLARE_MEMBERS(Assoc);
	Object* avalue;
protected:		// storer() functions for object I/O
	virtual void storer(OIOofd&) const;
	virtual void storer(OIOout&) const;
public:
	Assoc(Object& newKey =*nil, Object& newValue =*nil);
	virtual void deepenShallowCopy();
	virtual Object* value() const;
	virtual Object* value(Object& newvalue);
};

#endif
