// ex6-4.c -- Calling a virtual function from a base class constructor

// $Header: ex6-4.c,v 2.204 89/10/08 14:41:57 keith Stab $

#include <iostream.h>

class A {
public:
    virtual void vf();
};

void A::vf()    { cout << "A::vf()" << endl; }

class B: public A {
public:
    B()         { vf(); }   // Calls A::vf(), not C::vf()
};

class C: public B {
public:
    C()         { vf(); }   // Calls C::vf()
    virtual void vf();
};

void C::vf()    { cout << "B::vf()" << endl; }

main()
{
    C c;
}
