#ifndef ERRORSH
#define ERRORSH

// $Header: errors.h,v 2.204 89/10/08 14:11:04 keith Stab $

/* errors.h -- Error facility declarations

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	S.M. Orlow
	Systex,Inc.
	Beltsville, MD 20705
	301-474-0111
	June, 1986

Contractor:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov

$Log:	errors.h,v $
 * Revision 2.204  89/10/08  14:11:04  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/09  10:21:37  keith
 * Pre-release
 * 
 * Revision 1.3  89/08/09  10:16:32  keith
 * Pre-release
 * 
 * Revision 1.2  89/06/21  14:28:35  sandy
 * modified seterror to make use of variable length argument list portable
 * 
 * Revision 1.1  89/05/26  17:43:17  keith
 * Initial revision
*/

#include <stream.h>

const int MAX_MSG_ARG =	8;      /* max numbers of args per msg */
const int MAX_FACILITIES = 32;  /* max no. of facilities */
const int SYS_LAST_ERROR = 34;	/* last UNIX system error */

/* severity levels */
enum severity_level { SUCCESS = 0,
		      INFORMATION = -1,
		      INFO = -1,
		      WARNING = -2,
		      ERROR = -3,
		      FATAL = -4,
		      DEFAULT = 1 };

/* Error Code Definition */
const int FAC_SHIFT =    12;	    // right shift count to get facility code
const int OFFSET_MASK =  0xfff;     // mask for offset portion of error 
const int FAC_MASK =     0xfff000;  // mask for facility portion 

inline int FACILITY_CODE(int ER) { return ((ER&FAC_MASK)>>FAC_SHIFT); }
inline int OFFSET_INDEX(int ER)  { return (ER&OFFSET_MASK); }

class ErrSpecs {
public:
	int severity;		/* severity of this error */
	char* args;		/* error msg args: I=int, S=string,D=double */
	char* text;		/* printf format string for error text */
	};


class ErrFac {
public:
	char* longname;		/* facility long name for the error msgs */
	ErrSpecs* errlist;	/* all errors for this facility */
	int last;		/* last error in this facility */
};

extern "C" {
void seterropt(int esev, int psev, int dump, int fmt, FILE*);
void geterropt(int& esev,int& psev,int& dump,int& fmt,FILE*&);
int seterror(int err, int sev, ...);

ErrFac* errfac_at(int err);
int errfac_severity(int err);
char* errfac_errorText(int err, char* buf =0);
void errfac_prepText(char* p, char* q);
void errfac_prepNextArg(char* p,char* q);
char* errfac_argumentCodes(int err);
void errfac_errorMessage(int sev,char* msg);
int errfac_printSeverity();
int errfac_exitSeverity();
int errfac_isPrintSeverity(int s);
int errfac_isExitSeverity(int s);
}
#endif /* ERRORSH */
