#ifndef ERRLIBH
#define ERRLIBH

// $Header: errlib.h,v 2.204 89/10/08 14:11:00 keith Stab $

/* errlib.h -- header file for portable error facility

	THIS SOFTWARE FITS THE DESCRIPTION IN THE U.S. COPYRIGHT ACT OF A
	"UNITED STATES GOVERNMENT WORK".  IT WAS WRITTEN AS A PART OF THE
	AUTHOR'S OFFICIAL DUTIES AS A GOVERNMENT EMPLOYEE.  THIS MEANS IT
	CANNOT BE COPYRIGHTED.  THIS SOFTWARE IS FREELY AVAILABLE TO THE
	PUBLIC FOR USE WITHOUT A COPYRIGHT NOTICE, AND THERE ARE NO
	RESTRICTIONS ON ITS USE, NOW OR SUBSEQUENTLY.

Author:
	S.M. Orlow
	Systex,Inc.
	Beltsville, MD 20705
	301-474-0111
	June, 1986

Contractor:
	K. E. Gorlen
	Bg. 12A, Rm. 2017
	Computer Systems Laboratory
	Division of Computer Research and Technology
	National Institutes of Health
	Bethesda, Maryland 20892
	Phone: (301) 496-5363
	uucp: uunet!nih-csl!keith
	Internet: keith@alw.nih.gov

$Log:	errlib.h,v $
 * Revision 2.204  89/10/08  14:11:00  keith
 * Pre-release
 * 
 * Revision 2.203  89/08/09  10:21:33  keith
 * Pre-release
 * 
 * Revision 1.3  89/08/09  10:16:27  keith
 * Pre-release
 * 
 * Revision 1.2  89/06/21  14:37:09  sandy
 * added extern "C"
 * 
 * Revision 1.1  89/05/26  17:42:28  keith
 * Initial revision
*/

#include <stdio.h>

extern "C" {
void errprefix(const char*);
void errpostfix(const char*);
void formaterror(const char*,char*,int);
void seterropt(int esev,int psev,int dump,int fmt,FILE* filep);
void geterropt(int& esev,int& psev,int& dump,int& fmt,FILE*& filep);
void printerror(const char* prefix);
int seterror(int err,int sev, ... );

typedef int (*perrtrap)();
void seterrtrap(perrtrap func,int sev);
void clrerrtrap(int sev);
}
#endif /* ERRLIBH */

