#include <LEDA/rb_tree.h>
#include <LEDA/plane.h>
#include <LEDA/window.h>

window W(1150,900);

color node_color1 = black;
color node_color2 = red;
color edge_color  = blue;

void draw_black_node(double x, double y, void* i)
{ W.draw_filled_node(x,y,node_color1);
  W.draw_ctext(x,y,string("%d",i),white);
 }

void draw_red_node(double x, double y, void* i)
{ W.draw_filled_node(x,y,node_color2);
  W.draw_node(x,y,black);
  W.draw_ctext(x,y,string("%d",i),black);
 }

void draw_edge(double x0, double y0, double x1, double y1)
{ W.draw_edge(x0,y0,x1,y1,edge_color); }

void main()
{
  rb_tree T;
  panel P("RED BLACK TREES");

  int node_width = 12;
  int edge_width = 1;
  int n = 100;
  int mode = 0;

  if (W.mono()) node_color2 = white;
    
  P.choice_item("INPUT",mode,"random", "1..N");

  P.int_item("INSERTS",n);
  P.int_item("node width",node_width,1,20);
  P.int_item("edge width",edge_width,1,8,1);

  P.color_item("node color1",node_color1);
  P.color_item("node color2",node_color2);
  P.color_item("edge color", edge_color);

  for(;;)
  {
    P.open();

    W.clear();
    W.set_node_width(node_width);
    W.set_line_width(edge_width);
    W.set_text_mode(transparent);
  
    T.clear();
  
    init_random();
  
    if (mode==0)
      while (n--) T.insert((void*)random(0,99),0);
    else
      for(int i=0;i<n;i++) T.insert((void*)i,0);
  
    double dy = (W.ymax()-W.ymin())/10;
  
    T.draw(draw_red_node,draw_black_node,draw_edge,
           W.xmin(),W.xmax(),W.ymax()-dy,dy);
  
    W.read_mouse();
  
  }
  
}
