
#include <LEDA/window.h>
#include <LEDA/circle.h>
#include <time.h>
#include <math.h>

const char* monat[] =
{ "Januar",
  "Februar",
  "Maerz",
  "April",
  "Mai",
  "Juni",
  "Juli",
  "August",
  "September",
  "Oktober",
  "November",
  "Dezember"
};

const float pi_2 = 6.2835;

float radius;
float mx,my;
float s;
int m;
int sec;

window W(600,600);

color face_color   = white;
color text_color   = black;
color min_color    = white;
color hour_color   = white;
bool  numbers      = false;

color sec_color;

void hour_hand(float pos,int mode)
{ float length = 0.65 * radius;
  circle c(mx,my,radius/10);
  list(point) L;
  float phi = pi_2*pos/60;
  color bg = (hour_color == white) ? black : white;
  point p(mx+length*sin(phi),my+length*cos(phi));
  double l = c.left_tangent(p).direction();
  double r = c.right_tangent(p).direction();
  L.append(c.right_tangent(p).end());
  L.append(p);
  L.append(p.translate(l,1.2*length));
  L.append(p.translate(r,1.2*length));

  if (mode==0)
    { W.draw_filled_polygon(L,face_color);
      W.draw_polygon(L,face_color);
     }
  else
    { W.draw_filled_polygon(L,hour_color);
      W.draw_polygon(L,bg);
     }
}

void min_hand(float pos,int mode)
{ float length = 0.95*radius;
  circle c(mx,my,radius/13);
  list(point) L;
  float phi = pi_2*pos/60;
  color bg = (min_color == white) ? black : white;
  point p(mx+length*sin(phi),my+length*cos(phi));
  double l = c.left_tangent(p).direction();
  double r = c.right_tangent(p).direction();
  L.append(c.right_tangent(p).end());
  L.append(p);
  L.append(p.translate(l,1.15*length));
  L.append(p.translate(r,1.15*length));
  if (mode==0)
    { W.draw_filled_polygon(L,face_color);
      W.draw_polygon(L,face_color);
     }
  else
    { W.draw_filled_polygon(L,min_color);
      W.draw_polygon(L,bg);
      W.draw_disc(mx,my,radius/80,bg);
     }
}

void draw_sec(int i)
{ float x,y;
  if (i%5 != 0)
  { x = mx + radius*sin(pi_2*i/60);
    y = my + radius*cos(pi_2*i/60);
    W.draw_disc(x,y,radius/120,sec_color);
  }
}

void draw_clock()
{ 
  int i;
  float x,y;

  mx = (W.xmax()-W.xmin())/2;
  my = (W.ymax()-W.ymin())/2;

  radius = (mx < my) ? 0.9*mx : 0.9*my;

  W.draw_disc(mx,my,1.1*radius,face_color);
  W.draw_circle(mx,my,1.1*radius,text_color);

  for(i = 1; i<=12; i++)
  { x = mx + radius*sin(pi_2*i/12);
    y = my + radius*cos(pi_2*i/12);
    if (numbers)
      W.draw_text_node(x,y,string("%d",i),text_color);
    else
      W.draw_disc(x,y,radius/30,text_color);
   }

  sec_color = text_color;

  hour_hand(s,1);
  min_hand(m,1);

  for(i=0; i<=sec+2; i++) draw_sec(i);

 }

void move_hands(int min, int hour)
{ 

  hour_hand(s,0);
  min_hand(m,0);
  m = min;
  s = 5*(min/60.0 + hour);
  hour_hand(s,1);
  min_hand(m,1);

/*
  float p1 = m;
  float p2 = min;
  float step = (p2-p1)/8;
  int i;


  for(i=0;i<7;i++)
  { min_hand(p1,0);
    p1 += step;
    min_hand(p1,1); 
   }

  min_hand(p1,0);
  min_hand(p2,1);
*/

 }

  

  


void main()
{  
  W.set_redraw(draw_clock);

  panel P("clock panel");
  P.color_item("clock face", face_color);
  P.color_item("text color", text_color);
  P.color_item("minute hand",min_color);
  P.color_item("hour hand", hour_color);
  P.bool_item("numbers", numbers);
  P.button("continue");
  P.button("quit");

  long clock; 
  time(&clock);
  tm* T = localtime(&clock);
  m = T->tm_min;
  sec = T->tm_sec;
  s = 5*(m/60.0 + T->tm_hour);

  string datum("%d. %s 19%0d",T->tm_mday,monat[T->tm_mon], T->tm_year%100);

  W.set_frame_label(datum);

  draw_clock();

  double x,y;

  W.set_text_mode(opaque);
  for(;;)
  { 
    if (W.get_button()==3)
    { if (P.open()==1) break;
      W.clear();
      draw_clock();
     }

    time(&clock);
    T = localtime(&clock);
    sec = T->tm_sec;
    draw_sec(sec);

    if (m != T->tm_min) 
    { move_hands(T->tm_min,T->tm_hour);
      sec_color = (sec_color == text_color) ? face_color : text_color;
     }

  }

}
      
