#include <LEDA/graph.h>
#include <LEDA/graph_alg.h>

declare2(GRAPH,int,int);

void main()
{

GRAPH(int,int) G;
node s,v,w;
edge e;

int n = read_int("# nodes = ");
int m = read_int("# edges = ");

random_graph(G,n,m);

edge_array(int)  cost1(G,0);
node_array(int)  dist1(G,0);
node_array(int)  dist2(G,0);
node_array(edge) pred(G,nil);


int a = read_int("a = ");
int b = read_int("b = ");

forall_edges(e,G) cost1[e] = G[e] = random(a,b);

s = G.first_node();

float T = used_time();

cout << "DIJKSTRA (int)      ";
cout.flush();
DIJKSTRA(G,s,cost1,dist1,pred);
cout << string("%6.2f sec  \n",used_time(T));

cout << "BELLMAN_FORD (int)  ";
cout.flush();
BELLMAN_FORD(G,s,cost1,dist2,pred);
cout << string("%6.2f sec  \n",used_time(T));

if (Yes("Ausgabe ? "))
 { forall_nodes(v,G)
   { G.print_node(v);
    cout << string(" %6d %6d\n",dist1[v],dist2[v]);
    }
   newline;
  }


if (Yes("all pairs shortest paths (int) ? "))
{ 
  node_matrix(int) Mi(G);

  used_time(T);
  cout << "ALL PAIRS SHORTEST PATHS (int) ";
  cout.flush();
  ALL_PAIRS_SHORTEST_PATHS(G,cost1,Mi);
  cout << string("%.2f sec\n",used_time(T));
  
  if (Yes("Ausgabe ? "))
    forall_nodes(v,G)
     { forall_nodes(w,G) cout << string("%6d ",Mi(v,w));
       newline;
       }
  newline;
}


#ifndef __TURBOC__

edge_array(double) cost2(G,0);
node_array(double) dist3(G,0);
node_array(double) dist4(G,0);

forall_edges(e,G) cost2[e] = cost1[e];

cout << "DIJKSTRA (double)     ";
cout.flush();
DIJKSTRA(G,s,cost2,dist3,pred);
cout << string("%6.2f sec  \n",used_time(T));


cout << "BELLMAN_FORD (double) ";
cout.flush();
BELLMAN_FORD(G,s,cost2,dist4,pred);
cout << string("%6.2f sec  \n",used_time(T));


if (Yes("Ausgabe ? "))
 { forall_nodes(v,G)
   { G.print_node(v);
    cout << string(" %8.2f %8.2f\n",dist3[v],dist4[v]);
    }
   newline;
  }

if (Yes("all pairs shortest paths (double) ? "))
{ 
  node_matrix(double) Mr(G);

  used_time(T);
  cout << "ALL PAIRS SHORTEST PATHS (double)  ";
  cout.flush();
  ALL_PAIRS_SHORTEST_PATHS(G,cost2,Mr);
  cout << string("%.2f sec\n",used_time(T));
  
  if (Yes("Ausgabe ? "))
    forall_nodes(v,G)
     { forall_nodes(w,G) cout << string("%6.2f ",Mr(v,w));
       newline;
       }
  newline;

 }

#endif

}
