/*******************************************************************************
+
+  LEDA  2.2.0                                                 03-05-1992
+
+
+  array.h
+
+
+  Copyright (c) 1992  by  Max-Planck-Institut fuer Informatik
+  Im Stadtwald, 6600 Saarbruecken, FRG     
+  All rights reserved.
+ 
*******************************************************************************/




#ifndef ARRAYH
#define ARRAYH

#include <LEDA/basic.h>

//------------------------------------------------------------------------------
// array
//------------------------------------------------------------------------------



class gen_array {
	GenPtr* v;
	int sz;	
        int Low;
        int High;
        int t;
        int dir;


virtual int usr_cmp(GenPtr, GenPtr)  { return 0; }
virtual int cmp(GenPtr x, GenPtr y)        const { return int(x)-int(y); };
virtual void print_el(GenPtr& x,ostream& out) const { out << int(x); }
virtual void read_el(GenPtr& x,istream& in)         { in >> *(int*)&x; }
virtual void clear_entry(GenPtr& x) { x = 0; }
virtual void copy_entry(GenPtr& x)  { x = 0; }
virtual void init_entry(GenPtr& x)  { x = 0; }

        void quick_sort0(int l, int r);
        void quick_sort1(int l, int r);

protected:
        int  binary_search0(GenPtr);
        int  binary_search1(GenPtr);
        void sort(int,int,int); 

        void clear();

public:
        void init();
       ~gen_array() { delete v; }
	gen_array(int, int);
	gen_array(int);
	gen_array(gen_array&);
	gen_array& operator=(gen_array&);

        int      size()            { return sz; }
        int      low()             { return Low; }
        int      high()            { return High; }
	GenPtr& elem(int i)       { return v[i]; }
	GenPtr  elem(int i) const { return v[i]; }
	GenPtr& entry(int i)
	{ if (i<Low || i>High)
          error_handler(2,"array::entry index out of range");
          return v[i-Low];
         }
	GenPtr  inf(int i) const
	{ if (i<Low || i>High)
          error_handler(2,"array::inf index out of range");
          return v[i-Low];
         }

        void permute(int,int);
        void permute()  { permute(Low,High); }


   void print(ostream&,string, char space)   const;    
   void print(ostream& out,char space=' ') const { print(out,"",space);  }
   void print(string s, char space=' ')    const { print(cout,s,space);  }
   void print(char space=' ')              const { print(cout,"",space); }   


   void read(istream&,string);  
   void read(istream& in)      { read(in,"");  }
   void read(string s )        { read(cin,s);  }   
   void read()                 { read(cin,""); }   


};



#define array_body(type) : public gen_array {\
\
typedef int (*name2(type,_array_cmp))(type&,type&);\
\
type name2(type,X);\
\
name2(type,_array_cmp) cmp_ptr;\
\
int usr_cmp(GenPtr x, GenPtr y) \
                        { return cmp_ptr(ACCESS(type,x),ACCESS(type,y)); }\
int cmp(GenPtr x, GenPtr y) const\
                        { return compare(ACCESS(type,x),ACCESS(type,y)); }\
void print_el(GenPtr& x,ostream& out) const { Print(ACCESS(type,x),out);}\
void read_el(GenPtr& x,istream& in)         { Read(name2(type,X),in);\
                                              x = Copy(name2(type,X)); }\
void clear_entry(GenPtr& x)  { Clear(ACCESS(type,x)); }\
void copy_entry(GenPtr& x)   { x = Copy(ACCESS(type,x));  }\
void init_entry(GenPtr& x)   { Init(name2(type,X)); x = Copy(name2(type,X));}\
\
public:\
_array(type)(int a, int b)   : gen_array(a,b)             { init(); }\
_array(type)(int n)          : gen_array(n)               { init(); }\
_array(type)(_array(type)& A) : gen_array((gen_array&) A)  {}\
~_array(type)()                                           { clear(); }\
\
_array(type)& operator=(_array(type)& A)\
              { return (_array(type)&)gen_array::operator=((gen_array&) A); }\
type& operator[](int i)             { return ACCESS(type,entry(i)); }\
type  operator[](int i) const       { return ACCESS(type,inf(i)); }\
\
void sort(name2(type,_array_cmp) f) { cmp_ptr=f; gen_array::sort(low(),high(),1); }\
void sort(name2(type,_array_cmp) f,int l, int h)\
                                    { cmp_ptr=f; gen_array::sort(l,h,1); }\
void sort(int l, int h)             { gen_array::sort(l,h,0); }\
void sort()                         { gen_array::sort(low(),high(),0); }\
\
int binary_search(type x)   { return gen_array::binary_search0(Convert(x));}\
int binary_search(type x,name2(type,_array_cmp) f)\
               { cmp_ptr = f; return gen_array::binary_search1(Convert(x));}\
};

#ifdef __TEMPLATES__
#define _array(type) array
template<class type> class array array_body(type)

#else
#define _array(type) name2(type,array)
#define array(type) name2(type,array)
#define arraydeclare(type) class array(type) array_body(type)

#endif



/*------------------------------------------------------------------------*/
/* 2 dimensional arrays                                                   */
/*------------------------------------------------------------------------*/



class gen_array2 {
gen_array A;
int Low1, Low2, High1, High2;
virtual void clear_entry(GenPtr& x)  { x = 0; }
virtual void copy_entry(GenPtr& x)   { x = 0; }
virtual void init_entry(GenPtr& x)   { x = 0; }

protected:
void clear();
gen_array* row(int i) const { return (gen_array*)A.inf(i); }

public:
void init(int,int,int,int);
int low1()  { return Low1; }
int low2()  { return Low2; }
int high1() { return High1; }
int high2() { return High2; }
gen_array2(int,int,int,int);
gen_array2(int,int);
~gen_array2();
};


#define array2_body(type) : public gen_array2 {\
\
type name2(type,X);\
\
void clear_entry(GenPtr& x) { Clear(ACCESS(type,x)); }\
void copy_entry(GenPtr& x)  { x = Copy(ACCESS(type,x));  }\
void init_entry(GenPtr& x)  { Init(name2(type,X)); x = Copy(name2(type,X)); }\
\
public:\
\
type& operator()(int i, int j)       { return ACCESS(type,row(i)->entry(j)); }\
/*type  operator()(int i, int j) const { return ACCESS(type,row(i)->entry(j)); }*/\
\
 _array2(type)(int a,int b,int c,int d) :gen_array2(a,b,c,d){ init(a,b,c,d);}\
 _array2(type)(int n,int m)             :gen_array2(n,m)    { init(0,n-1,0,m-1);}\
~_array2(type)()                                            { clear();         }\
};

#ifdef __TEMPLATES__
#define _array2(type) array2
template<class type> class array2 array2_body(type)

#else
#define _array2(type) name2(type,array2)
#define  array2(type) name2(type,array2)
#define  array2declare(type) class array2(type) array2_body(type)

#endif


#endif
