#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************



CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
        Subroutine TekBox (term, NumTic, DXmax, DXmin, DYmax, DYmin,
     +                     fid)


**********************************************************
*                                                        *
*   Subroutine tektronix_4010/4014_Box                   *
*                                                        *
*      This subroutine is called by 'vttekd' or          *
*      'sund' or 'tekd'  to draw the axes, labels,       *
*      tic-marks (or grid), that is shown by the         *
*      window.                                           *
*                                                        *
**********************************************************

        Character *10   hix, hiy, lowx, lowy
        Common /winlbl/ hix, hiy, lowx, lowy
        Save   /winlbl/

        Logical        Gridon
        Integer                GType
        Common /grids/ Gridon, GType
        Save   /grids/

        Character       xaxis*20, yaxis*20, title*60
        Common /Labels/ xaxis, yaxis, title
        Save   /Labels/

        Integer NumTic(2), DXmax, DXmin, DYmax, DYmin, fid 
        Integer Tx, Ty, intvX, intvY, I, term
        Character hiX1, lwX1, hiY1, lwY1, extr1
        Character hiX2, lwX2, hiY2, lwY2, extr2
        Character lntyp(5)

*       (* Set up lntyp for current terminal *)
        IF (term .EQ. 4) THEN
          lntyp(1) = '`'
          lntyp(2) = 'a'
          lntyp(3) = 'b'
          lntyp(4) = 'c'
          lntyp(5) = 'd'
        ELSE
          lntyp(1) = 'h'
          lntyp(2) = 'i'
          lntyp(3) = 'j'
          lntyp(4) = 'k'
          lntyp(5) = 'l'
        ENDIF
*       (* Draw the viewport box for the window. *)
            Call tekcrd(DXmin, DYmin, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(DXmax, DYmin, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)
   10       Format (12a1)

            Call tekcrd(DXmax, DYmin, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(DXmax, DYmax, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)

            Call tekcrd(DXmax, DYmax, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(DXmin, DYmax, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)

            Call tekcrd(DXmin, DYmax, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(DXmin, DYmin, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)


*       (* Draw the labels for the xaxis, yaxis, title. *)
*         (* Y-axis *)
          Tx = 0
          Ty = (DYmax - DYmin)/2 + DYmin +50
          Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)
          Write (fid,20) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                 Char(31)
          Write (fid,20) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                 Char(31), yaxis(1:10)
          Call tekcrd(Tx, Ty -100, hiY1, lwY1, hiX1, lwX1, extr1)
          Write (fid,20) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                 Char(31), yaxis(11:20)
   20     Format (7a1,a10)

*         (* X-axis *)
          Tx = (DXmax - DXmin)/3 + DXmin
          Ty = DYmin -200
          Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)
          Write (fid,28) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                 Char(31), xaxis
   28     Format (7a1,a20)

*         (* title *)
          Tx = DXmin
          Ty = DYmax + 125
          Call tekcrd(Tx, Ty, hiY1, lwY1, hiX1, lwX1, extr1)
          Write (fid,30) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                 Char(31), title
   30     Format (7a1,a60)

*       (* Set the tick marks. Or draw the grid. *)
*       (* Set up line for grid *)
        Write (fid,33) Char(29), Char(27), lntyp(GType), Char(31)
   33   Format (4a1)
        Tx = (DXmax - DXmin)/(NumTic(1) +1)
        intvX = DXmin -25
        DO 100 I = 1, NumTic(1)
          If (Gridon) Then
            intvX = intvX + Tx
            Call tekcrd(intvX+35, DYmin, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(intvX+35, DYmax, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,35) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +  			    Char(31)
   35       Format (7a1)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)
          Else
            intvX = intvX + Tx
            Call tekcrd(intvX, DYmin -21, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,40) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +  			    Char(31)
   40       Format (7a1,'|')
            Call tekcrd(intvX, DYmax -21, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,40) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +	  		    Char(31)
          Endif
  100   CONTINUE

        Ty = (DYmax - DYmin)/(NumTic(2) +1)
        intvY = DYmin -40
        DO 200 I = 1, NumTic(2)
          If (Gridon) Then
            intvY = intvY + Ty
            Call tekcrd(DXmin, intvY+40, hiY1, lwY1, hiX1, lwX1, extr1)
            Call tekcrd(DXmax, intvY+40, hiY2, lwY2, hiX2, lwX2, extr2)
            Write (fid,35) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +  			    Char(31)
            Write (fid,10) Char(29), hiY1, extr1, lwY1, hiX1, lwX1,
     +                    hiY2, lwY2, hiX2, lwX2, extr2, Char(31)
          Else
            intvY = intvY + Ty
            Call tekcrd(DXmin -28, intvY, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,45) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +	  		    Char(31)
   45       Format (7a1,'-')
            Call tekcrd(DXmax -28, intvY, hiY1, lwY1, hiX1, lwX1, extr1)
            Write (fid,45) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +	  		    Char(31)
          Endif
  200   CONTINUE

*       (* Write out the window's max and min points. *)
*          (* Print the minimum X point. *)
           Call tekcrd(DXmin -20, DYmin -150, hiY1, lwY1, hiX1, lwX1, 
     +                 extr1)
           Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                  Char(31)
           Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                  Char(31), lowx
   50      Format (7a1,a10)

*          (* Print the maximum X point. *)
           Call tekcrd(DXmax -495, DYmin -150,hiY1, lwY1, hiX1, lwX1,
     +                 extr1)
           Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                  Char(31), hix

*          (* Print the minimum Y point. *)
           Call tekcrd(DXmin -700, DYmin, hiY1, lwY1, hiX1, lwX1, extr1)
           Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                  Char(31), lowy

*          (* Print the maximum Y point. *)
           Call tekcrd(DXmin -700, DYmax -100,hiY1, lwY1, hiX1, lwX1, 
     +                 extr1)
           Write (fid,50) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, 
     +                  Char(31), hiy


*
*   NO LONGER PRINTS OUT "LEGEND:"
*
*       (* Print out the legend title. *)
*       Call tekcrd(0, 300, hiY1, lwY1, hiX1, lwX1, extr1)
*       Write (fid,60) Char(29), hiY1, extr1, lwY1, hiX1, lwX1, Char(31)
*  60   Format (7a1,'Legend:')

        Return
        End
