#ifdef DYNIX
$stdunit
#endif DYNIX
*********************************************************
*                                                       *
*  Copyright 1988, by D.M. Etter, All rights reserved;  *
*          EECE Dept, University of New Mexico          *
*         Albuquereque, New Mexico,  87131  USA         *
*                                                       *
*********************************************************




CCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCCC
C
        Subroutine init (term, shadng, intpl)


**************************************************************
*                                                            *
*   This is an executable subroutine that initializes        *
*   values of the variables in the common blocks used        *
*   in this program.  The initializations are done in        *
*   subroutine, since multiple plots may be desired and      *
*   the block data statement only initializes the data       *
*   before run time.                                         *
*                                                            *
**************************************************************


        Character *7    crv(3)
        Common /Crvlbl/ crv
        Save   /Crvlbl/

        Character       xaxis*20, yaxis*20, title*60
        Common /Labels/ xaxis, yaxis, title
        Save   /Labels/

        Logical         cldrun
        Common /strtup/ cldrun
        Save   /strtup/

        Character ans
        Integer term
        Logical  shadng, intpl

        IF (.NOT. cldrun) THEN
   5      Call clear (term)
          Write (*,10)
  10      Format (5x,'Do you want all labels set to their'
     +            ' default values? (y,n)'/)
          Read (*,'(a1)',err=5) ans
        ELSE
          cldrun = .FALSE.
          ans = 'y'
        ENDIF

        IF (ans .EQ. 'Y' .OR. ans .EQ. 'y') THEN
*         (* Initialize the plot labels. *)
          xaxis = '      X-axis'
          yaxis = '  Y-axis'
          title = ' '
          title(22:) = 'XYPLOT Version 2'
          crv(1) = 'Curve 1'
          crv(2) = 'Curve 2'
          crv(3) = 'Curve 3'

*         (* Set shading and interpolation to false. *)
          shadng = .false.
          intpl = .false.
        ENDIF
 
        RETURN
        END
