/*****************************************************************************/
/* 				   error.c				     */
/*===========================================================================*/
/* 									     */
/*	error.c	takes care of generating useful error messages		     */
/* 									     */
/*	--  this file comes from _Introduction to Compiler Construction	     */
/*	    with Unix_ by Schreiner and Friedman			     */
/* 									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

#include <stdio.h>

/*......................... external connections ............................*/
extern	char	yytext[] ;
extern	int	yyleng ;
extern	int	yylineno ;
extern	int	yynerrs ;

/*............................ local variables ..............................*/
static	char	*source=0 ;
static	FILE	*yyerfp = stderr ;

/*---------------------------------------------------------------------------*/
/* 				   yywhere				     */
/*---------------------------------------------------------------------------*/
void
  yywhere ( )
{
	char	colon = 0 ;					   /* a flag */

	if( source && *source && strcmp(source,"\"\"") ) {
	    char	*cp = source ;
	    int	len = strlen(source) ;

	    if( *cp=='"' )
		++cp, len -= 2 ;
	    if( strncmp(cp,"./",2)==0 )
		cp += 2, len -=2 ;
	    fprintf(yyerfp,"file %.*s",len,cp) ;
	    colon = 1 ;
	}
	if( yylineno>0 ) {
	    if( colon )
		fputs(", ",yyerfp) ;
	    fprintf(yyerfp,"line %d",yylineno-(*yytext=='\n' || !*yytext)) ;
	    colon = 1 ;
	}
	if( *yytext ) {
	    register int	ii ;

	    for( ii=0 ; ii<20 ; ++ii )
		if( !yytext[ii] || yytext[ii]=='\n' )	break ;
	    if( ii ) {
		if( colon )	putc(' ',yyerfp) ;
		fprintf(yyerfp,"near \"%.*s\"",ii,yytext) ;
		colon = 1 ;
	    }
	}
	if( colon )
	    fputs(": ",yyerfp) ;
}

/*---------------------------------------------------------------------------*/
/* 				   yymark				     */
/*---------------------------------------------------------------------------*/
void
  yymark ( )
{
	if( source )	cfree(source) ;
	source = (char *)calloc(yyleng,sizeof(char)) ;
	if( source )
	    sscanf(yytext,"# %d %s",&yylineno,source) ;
}

/*---------------------------------------------------------------------------*/
/* 				   yyerror				     */
/*---------------------------------------------------------------------------*/
void
  yyerror ( msg )
char	*msg ;
{
	fprintf(yyerfp,"[error %d] ", yynerrs+1) ;
	yywhere() ;
	fputs(msg,yyerfp) ;
	putc('\n',yyerfp) ;
}
