/*****************************************************************************/
/* 				   calc.c				     */
/*===========================================================================*/
/* 									     */
/*	calc.c:  stores the motion calculation routines			     */
/* 									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

#include "runtime.h"
#include "calc.h"

/*---------------------------------------------------------------------------*/
/* 				  constant				     */
/*---------------------------------------------------------------------------*/
arg_t
  constant_i ( mtime , ptlist )
frm_t	mtime ;
point_t	*ptlist ;
{
	register arg_t	tmp ;

	tmp = (arg_t)malloc(sizeof(double)) ;
	if( tmp==0 ) {
	    yyerror("malloc failed in constant_i") ;
	    exit(-1) ;
	}
	tmp[0] = ptlist->samp ;
	free(ptlist) ;
	return(tmp) ;
}
double
  constant_c ( time , params )
frm_t	time ;
arg_t	params ;
{
	return(params[0]) ;
}
/*---------------------------------------------------------------------------*/
/* 				   linear				     */
/*	-- the linear equation is f(t) = mx + b				     */
/*	   where m is stored in param[0] and b in param[1]		     */
/*---------------------------------------------------------------------------*/
arg_t
  linear_i ( mtime , ptlist )
frm_t	mtime ;
point_t	*ptlist ;
{
	register arg_t	tmp ;

	tmp = (arg_t)malloc(sizeof(double)*2) ;
	if( tmp==0 ) {
	    yyerror("malloc failed in linear_i") ;
	    exit(-1) ;
	}
	tmp[1] = ptlist->samp ;					 /* find 'b' */
	tmp[0] = (ptlist->next->samp - ptlist->samp) / mtime ;	 /* find 'm' */
	free(ptlist->next) ;
	free(ptlist) ;
	return(tmp) ;
}
double
  linear_c ( time , params )
frm_t	time ;
arg_t	params ;
{
	return( time*params[0] + params[1] ) ;
}
/*---------------------------------------------------------------------------*/
/* 				  quadratic				     */
/*	-- the quadratic equation is f(t) = ax^2 + bx + c		     */
/*	   where a, b, c are stored in param 0, 1, 2 (respectively)	     */
/*---------------------------------------------------------------------------*/
arg_t
  quadratic_i ( mtime , ptlist )
frm_t	mtime ;
point_t	*ptlist ;
{
	register arg_t	tmp ;
	register double	p3, p2, p1 ;

	tmp = (arg_t)malloc(sizeof(double)*3) ;
	if( tmp==0 ) {
	    yyerror("malloc failed in quadratic_i") ;
	    exit(-1) ;
	}
	p1 = ptlist->samp ;
	p2 = ptlist->next->samp ;
	p3 = ptlist->next->next->samp ;
	tmp[0] = (3.0*p3/2 - p2)/(mtime*mtime) ;		 /* find 'a' */
	tmp[1] = (p2 - p3/2)/mtime ;				 /* find 'b' */
	tmp[2] = p1 ;
	free(ptlist->next->next) ;
	free(ptlist->next) ;
	free(ptlist) ;
	return(tmp) ;
}
double
  quadratic_c ( time , params )
frm_t	time ;
arg_t	params ;
{
	return( params[0]*time*time + params[1]*time + params[0] ) ;
}
