%{
/*****************************************************************************/
/* 				   anim.l				     */
/*===========================================================================*/
/* 									     */
/*	-- anim.l is the anim language parser				     */
/* 									     */
/*   Copyright (C) 1990 by Ron Sass.					     */
/*									     */
/*   Permission to use, copy, modify, and distribute this software and	     */
/*   its documentation for any purpose is hereby granted, provided that	     */
/*   no fee beyond distribution costs is charged, the above copyright	     */
/*   notice appear in all copies, and that both that copyright notice	     */
/*   and this permission notice appear in the supporting documentation.	     */
/*   This software is provided "as is" without express or implied warranty.  */
/* 									     */
/*****************************************************************************/

#ifdef DEBUG

#include <assert.h>
main() {
	char	*cp ;
	assert(sizeof(int)>=sizeof(char *)) ;
	while( cp=(char *)yylex() )
		printf("%-10.10s is \"%s\"\n",cp,yytext) ;
}
int	yynerrs = 0 ;
char	*yylval ;
#define	token(X)	(int) "X"

#else

#include "runtime.h"
#include "symbol.h"
#include "y.tab.h"
extern	sym_t	*yylval ;
#define	token(X)	X

#endif


%}

string		\"[^\"]*\"
digits		([0-9]+)
pt		"."
sign		[+-]?
exp		([Ee]{sign}{digits})
letter		[a-zA-Z_$]
let_or_dig	[a-zA-Z_$0-9]
white_space	[ \t\n]
other		.

%%

^"#"[ \t]*{digits}([ \t]+.*)?\n	yymark() ;

{sign}{digits}({pt}{digits})?{exp}?	|
{sign}{digits}?{pt}{digits}{exp}?	{  yylval=create_num() ;
				   return(token(NUMBER)) ;
				}

".."				return(token(DOTDOT)) ;

{string}			{  yylval=create_str() ;
				   return(token(IDENTIFIER)) ;
				}

{letter}{let_or_dig}*		{  yylval=create_id() ;
				   return(token(check())) ;
				}

{white_space}+			;

{other}				return(token(yytext[0])) ;

%%

#ifndef	DEBUG
/*===========================================================================*/
/* 				   check				     */
/*===========================================================================*/

int
  check ( )
{
	static struct {
	  char	*name ;
	  int	value ;
	} reswords[] = {
	  { "at" , AT },
	  { "cos" , COSINE },
	  { "do" , DO },
	  { "exp" , EXP },
	  { "gravity" , GRAVITY },
	  { "is" , IS },
	  { "log" , LOG },
	  { "sin" , SINE }
	} ;
	register int	idx ;

	for( idx=0 ; idx < (sizeof reswords)/(sizeof reswords[0]) ; idx++ )
	    if( strcmp(reswords[idx].name,yytext)==0 )
		return(reswords[idx].value) ;
	return(IDENTIFIER) ;
}
#endif
