/*
 * vfr_rletoD1.c - Use the Utah Raster Toolkit and the Video Framer library
 *                 to convert and send an "rle" file out the D1 port on i1.
 *
 * Written by:  Wesley C. Barris
 *              AHPCRC
 *              Minnesota Supercomputer Center, Inc.
 * Date:        July, 2, 1991
 * Copyright @ 1991, Minnesota Supercomputer Center, Inc.
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 *
 * To compile and link this program, do this:
 * cc -O -I/usr/video/vfr/src/inc -o vfr_rletoD1 vfr_rletoD1.c -lvfr_s -lm
 *
 * Usage: vfr_rletoD1 filename.rle
 */
#include <stdio.h>
#include <string.h>
#include <sys/types.h>
#include <sys/utsname.h>
#include <vframer.h>
#define VFR_ALPHALS(x)           (((x) & 0x0000FF) << 24)

VFR_DEV	*vfr;

#define XABEKAS		720.0
#define YABEKAS		486.0

main(argc, argv)
int argc;
char **argv;
{
   FILE	*pixin;
   char			cmd[256], *index, fname[80];
   unsigned char	*wbuf, *yptr;
   int			width, height, nchan, bufsiz;
   int			c;
   int			i, x, y;
   int			toright = 0;
   int			toleft = 0;
   int			mode;
   int			noinit = 0;
   struct utsname	name;
   int			xorg, yorg;
   float		scale;
   extern char		*optarg;
   extern int		optind;
/*
 *  Are we on a valid machine?
 *   char sysname[9];
 *   char nodename[9];
 *   char release[9];
 *   char version[9];
 *   char machine[9];
 */
   uname(&name);
   if (strcmp(name.nodename, "i1")) {
      fprintf(stderr, "%s will only run on i1.\n", argv[0]);
      exit(-1);
      }
/*
 *  Do we have standard input or a file name?
 */
   while ((c = getopt(argc, argv, "l:r:z")) != -1)
      switch (c) {
         case 'l':
            sscanf(optarg, "%d", &i);
            if (i >= 1)
               toleft = i;
            else {
               fprintf(stderr, "Invalid shift %d\n", i);
               exit(0);
               }
            break;
         case 'r':
            sscanf(optarg, "%d", &i);
            if (i >= 1)
               toright = i;
            else {
               fprintf(stderr, "Invalid shift %d\n", i);
               exit(0);
               }
            break;
         case 'z':
            noinit = 1;		/* do not initialize the frame */
            break;
         default:
            fprintf(stderr, "Usage: vfr_rletoD1 [-l n|-r n] filename\n");
            exit(0);
         }
   if (argv[optind] == NULL)
      if (toleft || toright) {
         fprintf(stderr, "Sorry, you cannot shift an image read from stdin.\n");
         exit(0);
         }
      else
         sprintf(cmd, "rletoraw -s");
   else {
      strcpy(fname, argv[optind]);
      sprintf(cmd, "rlehdr -b -h %s", fname);

   /*(if (argc == 1)
      sprintf(cmd, "rletoraw -s");
   else if (argc == 2) {
      sprintf(cmd, "rlehdr -b -h %s", fname);*/
/*
 *  We have a file name -- we can check its format.
 */
      if ((wbuf = (unsigned char *) malloc(80)) == NULL)
         fprintf(stderr, "Cannot malloc 80 bytes.\n");
      if ((pixin = popen(cmd, "r")) == NULL)
         fprintf(stderr, "Cannot open pipe.\n");
      fread(wbuf, 80, 1, pixin);
      pclose(pixin);
      index = strrchr((char *)wbuf, '[');
      sscanf(++index, "%d,%d", &width, &height);
      index = strrchr((char *)wbuf, 'x');
      sscanf(++index, "%d", &nchan);
      free(wbuf);
      if ((width != XABEKAS || height != YABEKAS) && nchan == 3) {
         fprintf(stderr, "This image (%dx%d) is not the correct size for the Abekas -- scaling.\n", width, height);
         if (XABEKAS/width > YABEKAS/height) {
            scale = YABEKAS/height;
            xorg = 0.5*(XABEKAS - scale*width);
            yorg = 0;
            }
         else {
            scale = XABEKAS/width;
            xorg = 0;
            yorg = 0.5*(YABEKAS - scale*height);
            }
         sprintf(cmd, "rlezoom %f %s | repos -p %d %d | crop 0 0 719 485 | rletoraw -s", scale, fname, xorg, yorg);
         }
      else if ((width != XABEKAS || height != YABEKAS) && nchan != 3) {
         fprintf(stderr, "This image (%dx%d) is not the correct size for the Abekas nor does it have 3 color channels -- scaling and applying the map.\n", width, height);
         if (XABEKAS/width > YABEKAS/height) {
            scale = YABEKAS/height;
            xorg = 0.5*(XABEKAS - scale*width);
            yorg = 0;
            }
         else {
            scale = XABEKAS/width;
            xorg = 0;
            yorg = 0.5*(YABEKAS - scale*height);
            }
         sprintf(cmd, "applymap %s | rlezoom %f | repos -p %d %d | crop 0 0 719 485 | rletoraw -s", fname, scale, xorg, yorg);
         }
      else if (nchan != 3) {
         fprintf(stderr, "Applying color map to image data to produce 3 color channels...\n");
         sprintf(cmd, "applymap %s | rletoraw -s", fname);
         }
      else
         if (toleft)
            sprintf(cmd, "crop %d 0 %d %d %s | rletoraw -s", toleft, width-1+toleft, height-1, fname);
         else if (toright)
            sprintf(cmd, "repos -p %d 0 %s | crop 0 0 719 486 | rletoraw -s", toright, fname);
         else
            sprintf(cmd, "rletoraw -s %s", fname);
      }
   /*else {
      fprintf(stderr, "Usage: vfr_rletoD1 filename.rle\n");
      exit(-1);
      }*/
   width  = XABEKAS;
   height = YABEKAS;
   nchan  = 3;
/*
 *  Get some memory, open a pipe, and read the rle file.
 */
   bufsiz = width*height*nchan;
   if ((wbuf = (unsigned char *) malloc(bufsiz)) == NULL)
      fprintf(stderr, "Cannot malloc %d bytes.\n", bufsiz);
   if ((pixin = popen(cmd, "r")) == NULL)
      fprintf(stderr, "Cannot open pipe.\n");
   if ((fread(wbuf, bufsiz, 1, pixin)) != 1) {
      fprintf(stderr, "Couln't read %d bytes.\n", bufsiz);
      exit(-1);
      }
   pclose(pixin);
/*
 *  Display the result -- used only for testing purposes.
 */
   /*prefposition(10, 10 + width - 1, 10, 10 + height - 1);
   foreground();
   winopen("vfr_rletoA60 test");
   RGBmode();
   gconfig();
   for (i=0, yptr=wbuf; i<height; i++, yptr += width*nchan) {
      cmov2i(0, i);
      writeRGB(width, yptr, yptr+width, yptr+width*2);
      }*/
/*
 *  Open the Video Framer.
 */
   if (noinit)
      mode = -VFR_CUSTOM_SETUP;
   else
      mode = VFR_CUSTOM_SETUP;
   /*vfr = vfr_open(DEFAULT_VFR_ADDR, mode, "vfr_d1_525");*/
   vfr = vfr_open(DEFAULT_VFR_ADDR, VFR_D1_525, (unsigned char *)"");
/*
 *  Here is a quick and dirty way of trying two methods of filling
 *  the shadow buffer.  This should yield the same result but it
 *  doesn't and neither produces correct results.
 */
   /*if (0)
      lrectread(0, 0, 1023, height-1, VFR_DEVICE_PSHADOW(*vfr));
   else*/
      for (y=0, i=height-1; y<height; y++, i--)
         for (x=0; x<width; x++)
            VFR_DEVICE_PSHADOW(*vfr)[y*D1_LINE_LENGTH + x] =
		    VFR_REDLS(wbuf[(i*nchan  )*width + x]) |
                  VFR_GREENLS(wbuf[(i*nchan+1)*width + x]) |
                   VFR_BLUELS(wbuf[(i*nchan+2)*width + x]);
/*
 *  Pull the stuff out of the shadow buffer to see if it was written
 *  corectly.
 */
   /*lrectwrite(0, 0, width-1, height-1, VFR_DEVICE_PSHADOW(*vfr));*/
/*
 *  Convert to D1...
 *  What should the pix_per_line be -- the width of my image?
 */
   if  (!vfr_convert_from_rgb(vfr, width))
      fprintf(stderr, "Cannot convert the image.\n");
   if (!vfr_close(vfr))
      fprintf(stderr, "I'm having trouble closing the Video Framer.\n");
   free(wbuf);
}
