/*
 * file:     main.c
 * author:   Wes Barris
 * date:     10/15/93
 * purpose:  X/GL-based image colorspace tester
 *
 * copyright info:
 *
 *    @Copyright, Research Equipment Inc., d/b/a Minnesota Supercomputer
 *    Center, Inc., 1993
 *
 * RESTRICTED RIGHTS LEGEND
 *
 * Use, duplication, or disclosure of this software and its documentation
 * by the Government is subject to restrictions as set forth in subdivision
 * { (b) (3) (ii) } of the Rights in Technical Data and Computer Software
 * clause at 52.227-7013.
 */

#include "icop.h"
#include "proto.h"
#include <gl/gl.h>
#include <X11/Shell.h>
#include <X11/StringDefs.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/MwmUtil.h>
#include <X11/Xmu/Editres.h>

extern  int _EditResCheckMessages();

ICOP	icop;
char	systype[10];

main(argc, argv)
unsigned int	argc;
char	*argv[];
{
   Widget	form, w, ip,
		menubar;
   int		n;
   Arg		args[10];

   if (getgdesc(GD_BITS_NORM_DBL_RED) == 0) {
      printf("Sorry, this program requires double buffered RGB mode.\n");
      exit(1);
      }
   n = 0;
   icop.toplevel = XtAppInitialize(&(icop.appContext), APP_CLASS, NULL,
      NULL, &argc, argv, NULL, args, n);
   XtAddEventHandler(icop.toplevel, (EventMask)0, True,
                     (XtEventHandler)_EditResCheckMessages, NULL);
   XSynchronize(XtDisplay(icop.toplevel), True);
   gversion(systype);
/*
 * Icop is held together by a form.
 */
   n = 0;
   form = XmCreateForm(icop.toplevel, "form", args, n);
   XtManageChild(form);
/*
 * Create Icop's main children.
 */
   menubar	=	MenuBarInit(form);
   ip		=	InfoInit(form, menubar);
   icop.plot.w	=	PlotInit(form, ip);
   icop.image.w	=	NULL;
   icop.image.width = 0;
   icop.image.height = 0;
/*
 * Anything that needs to be initialized...
 */
   icop.image.legalbuf = NULL;
   icop.image.illegalbuf = NULL;
   icop.image.correctedbuf = NULL;
   XtRealizeWidget(icop.toplevel);
/*
 * Let's go!
 */
   XtAppMainLoop(icop.appContext);
   exit(0);
}
