/*****************************************************************************
*   "Irit" - the 3d polygonal solid modeller.				     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Jan. 1992   *
******************************************************************************
* Global definitions of	wntdrvs interface.			             *
*****************************************************************************/

#ifndef	WNTDRVS_H	/* Define only once */
#define	WNTDRVS_H

#define APP_CLASS		"wntdrvs"
#define APP_TITLE		"Irit Display Device"
#define APP_MENU		1000
#define APP_VIEW_CLASS		"IritViewClass"
#define APP_TRANS_CLASS		"IritTransClass"

#define IDM_FILE		1
#define IDM_FILE_SAVE		11
#define IDM_FILE_SAVE_AS	12
#define IDM_FILE_QUIT		13

#define IDM_MOUSE		2
#define IDM_MOUSE_MORE		21
#define IDM_MOUSE_LESS		22

#define IDM_STATE		3
#define IDM_STATE_MORE_ISO	31
#define IDM_STATE_LESS_ISO	32
#define IDM_STATE_FINER_APPROX	33
#define IDM_STATE_COARSER_APPROX 34
#define IDM_STATE_SHORTER_VEC	35
#define IDM_STATE_LONGER_VEC	36
#define IDM_STATE_WIDE_LINES	37
#define IDM_STATE_THIN_LINES	38

#define IDM_TOGGLE		4
#define IDM_TGLS_SCREEN		41
#define IDM_TGLS_PERSP		42
#define IDM_TGLS_DEPTH_CUE	43
#define IDM_TGLS_DOUBLE_BUFFER  44
#define IDM_TGLS_DRAW_SOLID	45
#define IDM_TGLS_INTERNAL	46
#define IDM_TGLS_VRTX_NRML	47
#define IDM_TGLS_POLY_NRML	48
#define IDM_TGLS_CTL_MESH	49
#define IDM_TGLS_SRF_POLYS	50
#define IDM_TGLS_4_PER_FLAT	51

#define	IDM_VIEWS		6
#define	IDM_VIEW_FRONT		60
#define IDM_VIEW_SIDE		61
#define IDM_VIEW_TOP		62
#define IDM_VIEW_ISOMETRY	63

#define DEFAULT_TRANS_WIDTH	200
#define DEFAULT_TRANS_HEIGHT	500
#define DEFAULT_VIEW_WIDTH	400
#define DEFAULT_VIEW_HEIGHT	400
                                   
#define ARGCV_LINE_LEN	1000
#define ARGCV_MAX_WORDS	100

#define WNT_MAP_X_COORD(x) ((int) (IGViewWidth2 + x * IGViewWidth2))
#define WNT_MAP_Y_COORD(y) ((int) (IGViewHeight2 - y * IGViewHeight2))

#define SET_MENU_FLAGS(Bool)  (MF_STRING | (Bool ? MF_CHECKED : 0))

extern unsigned int
    IGViewWidth,
    IGViewHeight,
    IGViewWidth2,
    IGViewHeight2;
extern HBRUSH
    IGBackGroundBrush;
extern COLORREF
    IGBackGroundColor,
    IGCrntColorLowIntensity,
    IGCrntColorHighIntensity,
    IGColorsLowIntensity[IG_MAX_COLOR + 1],
    IGColorsHighIntensity[IG_MAX_COLOR + 1];
extern HPEN
    IGCurrenthPen;
extern HWND
    IGhWndView, IGhWndTrans;
extern HDC
    IGCurrenthDC;
extern HMENU
    IGGlblStateMenu;

int RedrawViewWindow(HWND hWnd, UINT wMsg, WPARAM wParam);
void IGSetColorIndex(int c);
void IGSetColorIndex2(int color, int width);
void IGSetColorRGB(int Color[3]);

#endif /* WNTDRVS_H */
