/*****************************************************************************
* Skeleton for an interface to a parser to read IRIT data files.	     *
*									     *
* Written by:  Gershon Elber				Ver 1.0, Feb 1993    *
*****************************************************************************/


#include <stdio.h>
#include "irit_sm.h"
#include "cagd_lib.h"
#include "symb_lib.h"
#include "iritprsr.h"
#include "attribut.h"
#include "allocate.h"

/*****************************************************************************
* DESCRIPTION:                                                               M
* Main module of skeletn1 - Read command line and do what is needed...	     M
*                                                                            *
* PARAMETERS:                                                                M
*   argc, argv:  Command line.                                               M
*                                                                            *
* RETURN VALUE:                                                              M
*   void                                                                     M
*                                                                            *
* KEYWORDS:                                                                  M
*   main                                                                     M
*****************************************************************************/
void main(int argc, char **argv)
{
    IPObjectStruct *PObjects, *PObj;

    /* Get the data from the input stream: */
    if ((PObjects = IritPrsrGetObjects(stdin)) == NULL)
	exit(1);

    /* Print the read geometry to stdout. */
    for (PObj = PObjects; PObj != NULL; PObj = PObj -> Pnext)
	IritPrsrPutObject(stdout, PObj);

    /* Do some symbolic manipulation of curves: */
    for (PObj = PObjects; PObj != NULL; PObj = PObj -> Pnext)
    {
	if (IP_IS_CRV_OBJ(PObj)) {
	    char *Err;
	    CagdCrvStruct
	        *DerivCrv = CagdCrvDerive(PObj -> U.Crvs),
		*DegreeRaiseCrv = CagdCrvDegreeRaise(PObj -> U.Crvs),
		*TanMagSqr = SymbCrvDotProd(DerivCrv, DerivCrv),
	        *DiffZero = SymbCrvSub(PObj -> U.Crvs, DegreeRaiseCrv);
	    CagdSrfStruct
	        *SrfOfRev = CagdSurfaceRev(PObj -> U.Crvs),
		*SweepSrf = CagdSweepSrf(PObj -> U.Crvs, PObj -> U.Crvs,
					 NULL, 1.0, NULL, FALSE);

	    CagdCrvWriteToFile2(DiffZero, stdout, 0, "A Zero Curve", &Err);
	    CagdCrvWriteToFile2(TanMagSqr, stdout, 0,
				"Magnitude of Tangent Square", &Err);
	    CagdCrvFree(DiffZero);
	    CagdCrvFree(TanMagSqr);
	    CagdCrvFree(DegreeRaiseCrv);

	    CagdSrfWriteToFile2(SrfOfRev, stdout, 0, "A Surface of revolution",
				&Err);
	    CagdSrfWriteToFile2(SweepSrf, stdout, 0, "A Sweep Surface",
				&Err);

	    CagdSrfFree(SrfOfRev);
	    CagdSrfFree(SweepSrf);
	}
    }
}

/*****************************************************************************
* DESCRIPTION:                                                               M
* Routine to process all surfaces/curves. Only concatenates the freeform     M
* geometry into one linked list.					     M
*   This function is a call back function of the irit parser.		     M
*                                                                            *
* PARAMETERS:                                                                M
*   CrvObjs:   Curve objects found on input stream.                          M
*   SrfObjs:   Surface objects found on input stream.                        M
*                                                                            *
* RETURN VALUE:                                                              M
*   IPObjectStruct *:   Linked list of both curves and surfaces.             M
*                                                                            *
* KEYWORDS:                                                                  M
*   IritPrsrProcessFreeForm                                                  M
*****************************************************************************/
IPObjectStruct *IritPrsrProcessFreeForm(IPObjectStruct *CrvObjs,
					IPObjectStruct *SrfObjs)
{
    fprintf(stderr, "IritPrsrProcessFreeForm invoked from the IritPrsr.\n");

    if (CrvObjs == NULL)
	return SrfObjs;
    else if (SrfObjs == NULL)
	return CrvObjs;
    else {
	IPObjectStruct *PTmp = CrvObjs;

	while (PTmp -> Pnext)
	    PTmp = PTmp -> Pnext;
	PTmp -> Pnext = SrfObjs;
	return CrvObjs;
    }
}
