
#include "extern.h"

/* The Yale sparse matrix package for non-symmetric matrices.
See smpak documentation for details. */

void    ndrv_(n, r, c, ic, ia, ja, a, b, z, nsp, isp, rsp, esp, path, flag)
int 	n, *r, *c, *ic, *ia, *ja, *isp, esp, path, flag, nsp;
double	*a, *b, *z, *rsp;
{
  	int	q, im, d, u, row, tmp, umax;
  	int     il=1, iu, jl, jlmax, max, jumax, ju, jutmp, l, j, lmax;
 	 
  	iu = il + n + 1;
  	jl = iu + n + 1;
 	 
  	if (path != 1)  goto two;
 	 
  	max = (LRATIO*nsp + 1 - jl) - (n+1) - n;
  	jlmax = max/2.0;
  	q = jl + jlmax;
  	im = q + (n+1);
  	jutmp = im + n;
  	jumax = LRATIO*nsp + 1 - jutmp;
  	esp = max/(double) LRATIO;

	if ((jlmax <= 0) || (jumax <= 0))	goto	one10;
	
	/* Recognize pattern of nonzero entries in coefficient matrix */
  	nsf_(n, r, ic, ia, ja, &isp[il-1], &isp[jl-1], jlmax, &isp[iu-1], &isp[jutmp-1], jumax, &isp[q-1], &isp[im-1], flag);

	if (flag != 0)	goto	one00;
	
  	jlmax = isp[il+n]-1;
  	ju = jl + jlmax;
  	jumax = isp[iu+n]-1;

  	if (jumax > 0)	{
  		for (j=1; j<=jumax; ++j)	{
    			isp[ju+j-1] = isp[jutmp+j-1];
  		}
	}
  
 	two:   
  	jlmax = isp[il+n] - 1;
  	ju = jl + jlmax;
  	jumax = isp[iu+n]-1;
  	l = (ju + jumax - 2 + LRATIO)/(double) LRATIO + 1;
  	lmax = jlmax;
  	d = l + lmax;
  	u = d + n;
  	row = nsp + 1 - n;
  	tmp = row - n;
  	umax = tmp - u;
  	esp = umax - jumax;

	if (umax <= 0)	goto	one10;

	/* Solve Newton linear system */
	nnf_(n, r, c, ic, ia, ja, a, z, b, &isp[il-1], &isp[jl-1], &rsp[l-1],
		lmax, &rsp[d-1], &isp[iu-1], &isp[ju-1], &rsp[u-1], umax, &rsp[row-1],
		&rsp[tmp-1], flag);

	if (flag != 0)	goto	one00;

	return;

	one00:	printf("Error in nsf() or nnf()\n");
		return;

	one10:	flag = 10*n + 1;
		printf("Insufficient storage in ndrv()\n");
		return;
}
	
	
/* Solve Newton linear system */
void nnf_(n, r, c, ic, ia, ja, a, z, b, il, jl, l, lmax, d, iu, ju, u, umax, row, tmp, flag)
int n, *r, *c, *ic, *ia, *ja, *il, *jl, lmax, *iu, *ju, umax, flag;
double *a, *z, *b, *l, *d, *u, *row, *tmp;
{
  	int k, i, jmin, jmax, j, imin, imax;
  	double li, sum, dk;

	if (il[n+1]-1 > lmax)	goto	one04;
	if (iu[n+1]-1 > umax)	goto	one07;

	
  	for(k=1;k<=n;k++){
    		jmin = il[k];
    		jmax = il[k+1] - 1;
    		if(jmin <=jmax){
      			for(j=jmin;j<=jmax;j++) 
				row[jl[j]]=0;
    		}
    		row[k]=0;
    		jmin = iu[k];
    		jmax = iu[k+1] - 1;
    		if(jmin <=jmax){
      			for(j=jmin;j<=jmax;j++) 
				row[ju[j]]=0;
    		}
    		jmin = ia[r[k]];
    		jmax = ia[r[k]+1]-1;
    		for(j=jmin;j<=jmax;j++) 
			row[ic[ja[j]]] = a[j];
    		sum = b[r[k]];
    		imin = il[k];
    		imax = il[k+1] -1;
    		if(imin <= imax){
      			for(i=imin; i<=imax; i++){
				li = -row[jl[i]];
				l[i] = -li;
				sum += li*tmp[jl[i]];
				jmin = iu[jl[i]];
				jmax = iu[jl[i]+1]-1;
				if(jmin <=jmax){
	   				for(j=jmin;j<=jmax;j++) 
						row[ju[j]]+=li*u[j];
	 			}
      			}
    		}
    		if(row[k]==0) {
      			flag = 8*n+ k;
      			return;
    		}

		if (row[k] == 0)	goto	one08;

    		dk = 1.0/row[k];
    		d[k]=dk;
    		tmp[k]= sum*dk;
    		jmin = iu[k];
    		jmax = iu[k+1]-1;
     		if(jmin <=jmax){
      			for(j=jmin;j<=jmax;j++) 
				u[j]=row[ju[j]]*dk;
    		}
  	}
  	k=n;
  	for(i=1;i<=n;i++){
    		sum=tmp[k];
    		jmin=iu[k];
    		jmax = iu[k+1]-1;
     		if(jmin <=jmax){
      			for(j=jmin;j<=jmax;j++) 
				sum -= u[j]*tmp[ju[j]];
    		}
    		tmp[k]=sum;
    		z[c[k]]=sum;
    		k-=1;
  	}
	flag=0;
	return;

	one04:	flag = 4*n + 1;
		printf ("Insufficient storage for l in nnf()\n");
		return;

	one07:	flag = 7*n + 1;
		printf ("Insufficient storage for u in nnf()\n");
		return;

	one08:	flag = 8*n + k;
		printf ("Zero pivot in nnf()\n");
		return;
} /* nnf */
	
/* Recognize pattern of nonzero entries in coefficient matrix 
This function should be called only on the first Newton iteration */
void nsf_(n, r, ic, ia, ja, il, jl, jlmax, iu, ju, jumax, q, im, flag)
int  n, *r, *ic, *ia, *ja, *il, *jl, *iu, *ju, *q, *im, flag, jlmax, jumax;
{
  	int m, qm, vj, jmin, jmax, k, j, i, jlptr=0, juptr=0;

  	il[1] = 1;
  	iu[1] = 1;

	for (k=1; k<=n; ++k)	{
		q[n+1] = n+1;
		jmin = ia[r[k]];
		jmax = ia[r[k]+1]-1;

		if (jmin > jmax)	goto	one01;

		for (j=jmin; j<=jmax; ++j)	{
			vj = ic[ja[j]];
			qm = n+1;
			one:	m = qm;
			qm = q[m];
			if (qm < vj)
				goto	one;

			if (qm == vj)	
				goto	one02;

			q[m] = vj;
			q[vj] = qm;
		}
		i = n+1;
		three:	
			i = q[i];
		if (i >= k)
			goto	seven;
		jlptr++;
		if (jlptr > jlmax)
			goto	one03;
		jl[jlptr] = i;
		qm = i;
		jmin = iu[i];
		jmax = im[i];
		if (jmin > jmax)
			goto	six;
		for (j=jmin; j<=jmax; ++j)	{
			vj = ju[j];
			if (vj == k)
				im[i] = j;
			four:	
				m = qm;
			qm = q[m];
			if (qm < vj)
				goto	four;
			if (qm == vj)
				goto	five;
			q[m] = vj;
			q[vj] = qm;
			qm = vj;
			five:	;
		}
		six:
			goto	three;
		seven:	
			if (i != k)
				goto	one05;
		eight:
			i = q[i];
			if (i <= n)	{
				juptr++;
				if (juptr > jumax)
					goto	one06;
				ju[juptr] = i;
				goto	eight;
			}
		nine:
			im[k] = juptr;
			il[k+1] = jlptr+1;
		ten:	iu[k+1] = juptr+1;
	}
	flag = 0;
	return;

	one01:	flag = n + r[k];
		printf ("Null row in a in nsf()\n");
		return;
	one02:	flag = 2*n + r[k];
		printf ("duplicate entry in a in nsf()\n");
		return;
	one03:	flag = 3*n + k;
		printf ("Insufficient storage for jl in nsf()\n");
		return;
	one05:	flag = 5*n + k;
		printf ("Null pivot in nsf()\n");
		return;
	one06:	flag = 6*n + k;
		printf ("Insufficient storage for ju in nsf()\n");
		return;
} /* nsf */
 
