#include 	"extern.h"

/* Functions that fill the domain with circles */

fillcircles(rad)
/* Fill the domain region with the regular hexagonal packing of mesh rad */
/* on output:	circles lying in region have state = CANDIDATE,
		others have state = OUTSIDE	*/
double	rad;
{
	int		i, j, k, x, y, u, v, indx, l, m, n;
	double		xlow, dx, dy, w, z;
	Bool		newloop;
	
	n = 2*rad;
	dx = 2.0*rad;
	dy = rad*ROOT3;
#ifdef DEBUG
	fprintf(stderr,"Filling with radius %4.1lf ...\n", rad);
#endif
	XESetFlushGC(dpy, 0, NULL);
	XFlush(dpy);
	XClearWindow(dpy, domainwin);
	XSetForeground(dpy, gc, 1);
	/* Draw the bounding curves if this is the initial fill */
	
	if (!subdividing)	{
		newloop = TRUE;
		for (i=0; i<normRgn; ++i)	{
			if (myRgnPoint[i].x < 0)	
				newloop = TRUE;
			else	{
				if (newloop)	{
					XDrawLine (dpy, domainwin, gc, myRgnPoint[i].x, myRgnPoint[i].y, myRgnPoint[i].x, myRgnPoint[i].y);
					newloop = FALSE;
				}
				else	XDrawLine (dpy, domainwin, gc, myRgnPoint[i-1].x, myRgnPoint[i-1].y, myRgnPoint[i].x, myRgnPoint[i].y);
			}
		}
	}

	x = y = numcircles = 0;
	
	/* Dimensions of array DCirc of centers */
	height = (ymax-ymin)/dy;
	width = (xmax-xmin)/dx;
	width = width + height/ROOT3 + 3;
	height += 5;
	hw = (width-1)*(height-1) + 1;

	/* Allocate circle arrays */
	initcircs();

	xlow = xmin - (ymax-ymin)/ROOT3 - 2.5*dx;
	w = ymin - 2.3*dy;
	/* check to see which circles are surrounded by others */
	for (i=0; i<height; i++) {
		w += dy;
		y = w;
		z = xlow;
		xlow += rad;
		x = z;
		for (j=0; j<width; j++) {
			z += dx;
			x = z;
			indx = j + i * width;
			DCirc[indx].state = XPointInRegion(myRegion, x, y) ? INTERIOR : 0;
			DCirc[indx].x = z;
			DCirc[indx].y = w;
			DCirc[indx].r = rad;
		}
	}
	countnbrs(INTERIOR);
	for (i=0 ; i< hw; ++i)
		if (DCirc[i].numnbr == NUMNBRS) DCirc[i].state = DEEPINSIDE; 

	/* Loop through, checking whether each admissible circle center lies in the region */
	for (i=0; i<height; ++i)	{
		for (j=0; j<width; ++j)	{
			indx = j+i*width;
			x = z = DCirc[indx].x;
			y = DCirc[indx].y;
			if (DCirc[indx].state > 0)	{
				/* Record fact in circleinfo array DCirc */
				++numcircles;
				DCirc[indx].state = CANDIDATE;
				DPlot[indx].x = DCirc[indx].x;
				DPlot[indx].y = DCirc[indx].y;
				DPlot[indx].state = DCirc[indx].state;
				/* Draw the circle */
				l = DCirc[indx].x-rad;
				m = DCirc[indx].y-rad;
				if ((drawdomain_flag) && (!subdividing))	{
					XFillArc(dpy, domainwin, gc, l, m, (int)n+1, (int)n+1, 0, X360DEGREES);
				}
			}
			else 	{
				DCirc[indx].state = OUTSIDE;
				DCirc[indx].r = -1;
			}
		}
	} 
	countnbrs(CANDIDATE);

	XSetForeground(dpy, gc, 1);

	if (!subdividing)
		fprintf (stderr,"%d circles\n", numcircles);

	XFlush(dpy);
} /*fillcircles*/
			

massagebdry()
/* If a domain border circle overlaps the boundary, move it in until it is tangent with the boundary. */
/* then draw the border circles of the domain */
{
	int		i, j, k, indx, innerindx, mypos[6][2];
	int		innercount, nextdex, movecount;
	double		moveangle, u1, v1, u2, v2, sixthPI = PI/6.0, movex, movey;
	
	XPoint		center, topleft, topright, bottomleft, bottomright;
	int		x, y, u, v, cpoints[200], maxm;
	double		r, theta, thetaoff, temp;
	Bool		circleinrgn, moving;
	
	theta = 0.0;
	r = fillrad*2;
	if (r > 200)	r = 200;
 	
	/* Maximum distance one is allowed to move a boundary circle */
	maxm = fillrad;
	
	/* Compute points on the circle lying in the first quadrant. */
	thetaoff = 180.0/r;
	for (k=0; k<r; k+=2)	{
		temp = (theta/180.0)*PI;
		cpoints[k] = fillrad*cos(temp);
		cpoints[k+1] = fillrad*sin(temp);
		theta += thetaoff;
	}
	temp = PI/2.0;
	cpoints[k] = fillrad*cos(temp);
	cpoints[k+1] = fillrad*sin(temp);
	
	XFlush(dpy);
	for (i=1; i<height-1; ++i)	{
		for (j=1; j<width-1; ++j)	{
			indx = j+i*width;
			if (DCirc[indx].state > INTERIOR)	{
				
				moving = TRUE;
				movecount = 0;
				while (moving)	{
				/* Check whether border circle lies entirely inside region */
					circleinrgn = TRUE;
					x = DCirc[indx].x;
					y = DCirc[indx].y;
					for (k=0; k<=(int)r; ++k)	{ 
						topright.x = x+cpoints[k]; 
						topright.y = y-cpoints[k+1]; 
						topleft.x = x-cpoints[k]; 
						topleft.y = y-cpoints[k+1]; 
						bottomright.x = x+cpoints[k]; 
						bottomright.y = y+cpoints[k+1]; 
						bottomleft.x = x-cpoints[k]; 
						bottomleft.y = y+cpoints[k+1]; 
						if ((!XPointInRegion(myRegion, topright.x, topright.y)) 
						|| (!XPointInRegion(myRegion, topleft.x, topleft.y)) 
						|| (!XPointInRegion(myRegion, bottomright.x, bottomright.y)) 
						|| (!XPointInRegion(myRegion, bottomleft.x, bottomleft.y)))	{
							circleinrgn = FALSE;
							break;
						}
						if (!circleinrgn)	break;
					}
					
					if (circleinrgn)	{
					/* Border circle does not need to be moved */
						moving = FALSE;
					}
					else	{
					/* Circle overlaps boundary; move the circle toward the inside until it does lie in the region. */
						if (movecount == 0)	{
						/* Find average of angles to neighboring inner circles */
						/* The border circle will be moved in this direction */
							u1 = DCirc[indx].x;
							v1 = DCirc[indx].y;
							innercount = 0;
							getccindices(i, j, mypos);
							for (k=0; k<6; ++k)	{
								innerindx = mypos[k][1] + mypos[k][0]*width;
								nextdex = mypos[(k+1)%6][1] + mypos[(k+1)%6][0]*width;
								if (DCirc[innerindx].state == INTERIOR)	
									++innercount;
								if ((DCirc[innerindx].state > INTERIOR)
								&& (DCirc[nextdex].state == INTERIOR))	{
									u2 = DCirc[nextdex].x;
									v2 = DCirc[nextdex].y;
									moveangle = atan2 (v2-v1, u2-u1);
								}
							}
							moveangle = moveangle - (innercount-1)*sixthPI;
							/* The unit move vector */
							movex = cos(moveangle);
							movey = sin(moveangle);
						}
						/* Move center of border circle */
						DCirc[indx].x += movex;
						DCirc[indx].y += movey;
						++movecount;

						if (movecount > maxm)	{
						/* Stop moving */
							moving = FALSE;
						}
					}
				}
			}
		}
	}

	/* Draw the border circles */
	normbdry = 0;
	for (i=0; i<mynorm; ++i)	{
		if (DCirc[myindex[i]].state > INTERIOR)	{
			++normbdry;
			j = DCirc[myindex[i]].x-fillrad;
			k = DCirc[myindex[i]].y-fillrad;
			XSetForeground(dpy, gc, mycolor[i]);
			XDrawArc(dpy, domainwin, gc, j, k, (int)(2*fillrad+1), (int)(2*fillrad+1), 0, X360DEGREES);
		}
	}
	/* Number of edge intersection angles that must be stored */
	normbdry *= AVE_EDGES;
	XFlush(dpy);
} /*massagebdry*/

