#include "extern.h"

/* All these functions either allocate or deallocate memory */

initcircs()	{
/* Allocate memory for arrays recording the circles' positions, radii, etc.*/
	int	j;

	j = width*height;
	RHole = (circleinfo *) XtCalloc(MAXHOLES, sizeof(circleinfo));
	DHole = (circleinfo *) XtCalloc(MAXHOLES, sizeof(circleinfo));
	DCirc = (circleinfo *) XtCalloc(j, sizeof(circleinfo));
	RCirc = (circleinfo *) XtCalloc(j, sizeof(circleinfo));
	DPlot = (plotinfo *) XtCalloc(j, sizeof(plotinfo));
	RPlot = (plotinfo *) XtCalloc(j, sizeof(plotinfo));
} /*initcircs*/
				
initedge()	{
/* Allocate memory for myedge array */
	/* myedge is used only in the Thurston boundary modification, where circles 
	near the border intersect at prescribed angles */
	myedge = (edgeinfo *) XtCalloc(normbdry, sizeof(edgeinfo));
} /*initedge*/
				
initguess()	{
/* Allocate memory for radius guess arrays.*/
	/* These arrays are used for making a better initial radius guess based upon a previous run */
	GCirc = (circleinfo *) XtCalloc(width*height, sizeof(circleinfo));
	GHole = (circleinfo *) XtCalloc(MAXHOLES, sizeof(circleinfo));
} /*initguess*/

	
endcircs()	{
/* Deallocate memory for circle arrays */
	XtFree((char*) RHole);
	XtFree((char*) DHole);
	XtFree((char*) DCirc);
	XtFree((char*) RCirc);
	XtFree((char*) DPlot);
	XtFree((char*) RPlot);
	XtFree((char*) mycolor);
} /*endcircs*/

endedge()	{
/* Deallocate memory for array myedge */
	XtFree((char*) myedge);
} /*endedge*/

endguess()	{
/* Deallocate memory for radius guess arrays */
	XtFree((char*) GCirc);
	XtFree((char*) GHole);
} /*endguess*/

endNDRVargs()	{
/* Deallocate memory for arrays used in Newton's method */
	XtFree ((char *) z);
	XtFree ((char *) mynum);
	XtFree((char*) myrow);
	XtFree ((char *) phi);
	XtFree ((char *) d0phi);
	XtFree ((char *) d1phi);
	XtFree ((char *) curvature);
	XtFree((char*) R);
	XtFree((char*) C);
	XtFree((char*) IC);
	XtFree((char*) IA);
	XtFree((char*) JA);
	XtFree((char*) A);
	XtFree((char*) ISP);
	XtFree((char*) RSP); 
} /* endNDRVargs */ 

initNDRVargs()	{
/* Allocate necessary arrays for the smpak sparse matrix function ndrv().
 See the smpak documentation for details */
	int	maxlength;	/* Maximum number of neighboring circles; = 6 if the domain is simply connected */
	int	i, NSP = 500*N;

	maxlength = 6;
	for (i=0; i<numholes; ++i)
		if (maxlength < DHole[i].state)		maxlength = DHole[i].state;	

	mynum = (int *) XtCalloc (maxlength, sizeof(int));
	z = (double *) XtCalloc (maxlength, sizeof(double));

	phi = (double *) XtCalloc (maxlength+1, sizeof(double));
	d0phi = (double *) XtCalloc (maxlength+1, sizeof(double));
	d1phi = (double *) XtCalloc (maxlength+1, sizeof(double));
	myrow = (rowpartial*) XtCalloc(maxlength+2, sizeof(rowpartial));

	/* The curvature vector holds the curvatures upon input to the smpak function ndrv().
	 ndrv() returns the radii increments in the curvature vector */
	curvature = (double *) XtCalloc (N+2, sizeof (double));
	R = (int*) XtCalloc(N+1, sizeof(int));
	C = (int*) XtCalloc(N+1, sizeof(int));
	IC = (int*) XtCalloc(N+1, sizeof(int));
	for (i=1; i<=N; ++i)	
		R[i] = C[i] = IC[i] = i;
	IA = (int*) XtCalloc(N+1+1, sizeof(int));
	JA = (int*) XtCalloc(7*N+1, sizeof(int));
	A = (double*) XtCalloc(7*N+1, sizeof(double));
	ISP = (int*) XtCalloc(LRATIO*NSP+1, sizeof(int));
	RSP = (double*) XtCalloc(NSP+1, sizeof(double)); 
	if (RSP == NULL)	
		exit(printf("initNDRVargs: unable to allocate RSP of size %d\n",
		(NSP+1)*sizeof(double)));
} /* initNDRVargs */
