
/*
 * Copyright (c) 1990, Geometry Supercomputer Project
 *                     University of Minnesota 
 *                     1200 Washington Ave. S
 *                     Minneapolis, MN  55415
 *
 *
 * This software is copyrighted as noted above.  It may be freely copied,
 * modified, and redistributed, provided that the copyright notice is
 * preserved on all copies.
 *
 * There is no warranty or other guarantee of fitness for this software,
 * it is provided solely "as is".  Bug reports or fixes may be sent
 * to the authors, who may or may not act on them as they desire.
 *
 * You may not include this software in a program or other software product
 * without supplying the source, or without informing the end-user that the
 * source is available for no extra charge.
 *
 * If you modify this software, you should include a notice giving the
 * name of the person performing the modification, the date of modification,
 * and the reason for such modification.
 *
 *  Written by Steve Anderson and Toby Orloff, summer 1990.
 */

#include "omni_proc.h"

main(argc, argv)
int argc;
char **argv;
{
  Initialize_globals ();
  global_init ();  /* This is user-defined, using omni_make */
  Parse (argc, argv);	/* (Contained in parse.c) */
  if (debug) printf ("%s %s %s\n", argv[0], argv[1], argv[2]);
  sprintf (infilename, "%s", argv[1]);
  sprintf (outfilename, "%s",  argv[2]);
  sprintf (outfileroot, "%s",  argv[2]);
  if ((type == ASCII) && (Check_if_binary (argv))) {
    fprintf (stderr, "%s: Warning: Input file looks like binary file, yet -bin not set.\n", argv[0]);
  }
  if (frames) {
    Animate (argv);
  } else {
    global_function ();
    Open_files (argv);
    Attack_data (argv);
    Close_files ();
  }
}

Animate (argv)
char **argv;
{
  char s[20];
  int i, digits;

  if (strcmp (outfileroot, "-") == 0) fprintf (stderr, "%s: Warning: Cannot send animation to stdout.\n", argv[0]);
  sprintf (s, "%d", frames-1);
  digits = strlen(s);
  sprintf (s, "%%s.%%0%dd%%s", digits);
  for (frame=0; frame<frames; frame++) {
    for (i=0; i<FMAX; i++) F[i] = oF[i]+dF[i]*((double)frame)/((double)frames);
    sprintf (outfilename, s, outfileroot, frame, suffix);
    global_function ();
    if (debug) {
      printf ("Frame %d: F = (", frame);
      for (i=0; i<FMAX; i++) printf ("%1.2f ", F[i]);
      printf (")\n");
      printf ("Outfile name is %s\n", outfilename);
    }
    Open_files (argv);
    Attack_data (argv);
    Close_files ();
  }
}

Initialize_globals ()
{
  int i;

  target = FLOAT_NOT_INT;
  skip = 0;
  chunk = 1;
  type = ASCII;
  frames = 0;
  frame = 0;
  debug = 0;
  sprintf (fformat, "%%f");
  for (i=0; i<FMAX; i++) {
    F[i] = 0.;
    dF[i] = 0.;
  }
  sprintf (suffix, "");
  sprintf (tag, "");
  tail = -1;
  A=0; B=0; C=0; D=0; E=0;
  J=0; K=0; L=0; M=0; N=0;
}

Check_if_binary (argv)
char **argv;
{
  FILE *fp;
  int i, ch, is_bin = 0;

  if(strcmp(infilename,"-") == 0) return 0;  /* Can't check stdin */

  if ((fp = fopen(infilename, "r")) == NULL) {
    fprintf (stderr, "%s: Cannot open input file %s.  Stop.\n", argv[0], infilename);
    exit (1);
  }
  for (i=0; (i<100) && (ch != EOF); i++) {
    ch = getc (fp);
    if (ch>127) is_bin = 1;
    if ((ch<8) || ((ch>10) && (ch<32))) is_bin = 1;
  }
  fclose (fp);
  return is_bin;
}
